/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.loader.client;

import java.util.ArrayList;
import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.minecraft.class_315;
import net.minecraft.class_3262;
import net.minecraft.class_3288;

@Mixin(class_315.class)
public class GameOptionsMixin {
	@Shadow
	public List<String> resourcePacks;

	@Inject(method = "load", at = @At("RETURN"))
	private void onLoad(CallbackInfo ci) {
		// Add built-in resource packs if they are enabled by default only if the options file is blank.
		if (this.resourcePacks.isEmpty()) {
			List<class_3288> profiles = new ArrayList<>();
			ModResourcePackCreator.CLIENT_RESOURCE_PACK_PROVIDER.register(profiles::add);
			this.resourcePacks = new ArrayList<>();

			for (class_3288 profile : profiles) {
				class_3262 pack = profile.method_14458();
				if (profile.method_29483() == ModResourcePackCreator.RESOURCE_PACK_SOURCE
						|| (pack instanceof ModNioResourcePack && ((ModNioResourcePack) pack).getActivationType().isEnabledByDefault())) {
					this.resourcePacks.add(profile.method_14463());
				}
			}
		}
	}
}
