/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.resource.loader.client.pack;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.GroupResourcePack;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3264;
import net.minecraft.class_3270;

/**
 * Represents the Programmer Art resource pack with support for modded content.
 *
 * <p>Any vanilla resources are provided like in Vanilla through the original programmer art, any missing resources
 * will be searched in the provided modded resource packs.
 */
@Environment(EnvType.CLIENT)
public class ProgrammerArtResourcePack extends GroupResourcePack {
	private final class_3255 originalResourcePack;

	public ProgrammerArtResourcePack(class_3255 originalResourcePack, List<ModResourcePack> modResourcePacks) {
		super(class_3264.field_14188, modResourcePacks);
		this.originalResourcePack = originalResourcePack;
	}

	@Override
	public InputStream method_14410(String fileName) throws IOException {
		if (!fileName.contains("/") && !fileName.contains("\\")) {
			// There should be nothing to read at the root of mod's Programmer Art extensions.
			return this.originalResourcePack.method_14410(fileName);
		} else {
			throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
		}
	}

	@Override
	public InputStream method_14405(class_3264 type, class_2960 id) throws IOException {
		if (this.originalResourcePack.method_14411(type, id)) {
			return this.originalResourcePack.method_14405(type, id);
		}

		return super.method_14405(type, id);
	}

	@Override
	public Collection<class_2960> method_14408(class_3264 type, String namespace, String prefix, Predicate<class_2960> predicate) {
		Set<class_2960> resources = new HashSet<>(this.originalResourcePack.method_14408(type, namespace, prefix, predicate));

		resources.addAll(super.method_14408(type, namespace, prefix, predicate));

		return resources;
	}

	@Override
	public boolean method_14411(class_3264 type, class_2960 id) {
		return this.originalResourcePack.method_14411(type, id) || super.method_14411(type, id);
	}

	@Override
	public Set<String> method_14406(class_3264 type) {
		Set<String> namespaces = this.originalResourcePack.method_14406(type);

		namespaces.addAll(super.method_14406(type));

		return namespaces;
	}

	@Override
	public <T> @Nullable T method_14407(class_3270<T> metaReader) throws IOException {
		return this.originalResourcePack.method_14407(metaReader);
	}

	@Override
	public String method_14409() {
		return "Programmer Art";
	}

	@Override
	public void close() {
		this.originalResourcePack.close();
		super.close();
	}
}
