/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader;

import com.mojang.datafixers.DataFixer;
import java.net.Proxy;
import java.util.List;
import net.fabricmc.fabric.impl.resource.loader.BuiltinModResourcePackSource;
import net.fabricmc.fabric.impl.resource.loader.FabricOriginalKnownPacksGetter;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin
implements FabricOriginalKnownPacksGetter {
    @Unique
    private List<KnownPack> fabric_originalKnownPacks;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(Thread serverThread, LevelStorageSource.LevelStorageAccess session, PackRepository dataPackManager, WorldStem saveLoader, Proxy proxy, DataFixer dataFixer, Services apiServices, LevelLoadListener chunkLoadProgress, CallbackInfo ci) {
        this.fabric_originalKnownPacks = saveLoader.resourceManager().listPacks().flatMap(pack -> pack.location().knownPackInfo().stream()).toList();
    }

    @Redirect(method={"configurePackRepository(Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/world/level/WorldDataConfiguration;ZZ)Lnet/minecraft/world/level/WorldDataConfiguration;"}, at=@At(value="INVOKE", target="Ljava/util/List;contains(Ljava/lang/Object;)Z"))
    private static boolean onCheckDisabled(List<String> list, Object o, PackRepository resourcePackManager) {
        String profileId = (String)o;
        boolean contains = list.contains(profileId);
        if (contains) {
            return true;
        }
        Pack profile = resourcePackManager.getPack(profileId);
        if (profile.getPackSource() instanceof BuiltinModResourcePackSource) {
            try (PackResources pack = profile.open();){
                ModNioResourcePack modPack;
                boolean bl = pack instanceof ModNioResourcePack && !(modPack = (ModNioResourcePack)pack).getActivationType().isEnabledByDefault();
                return bl;
            }
        }
        return false;
    }

    @Override
    public List<KnownPack> fabric_getOriginalKnownPacks() {
        return this.fabric_originalKnownPacks;
    }
}

