/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader;

import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.impl.resource.loader.FabricResourcePackProfile;
import net.fabricmc.fabric.impl.resource.loader.ResourcePackSourceTracker;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Pack.class})
abstract class PackMixin
implements FabricResourcePackProfile {
    @Unique
    private static final Predicate<Set<String>> DEFAULT_PARENT_PREDICATE = parents -> true;
    @Unique
    private Predicate<Set<String>> parentsPredicate = DEFAULT_PARENT_PREDICATE;

    PackMixin() {
    }

    @Shadow
    public abstract PackLocationInfo location();

    @Inject(method={"open"}, at={@At(value="RETURN")})
    private void onCreateResourcePack(CallbackInfoReturnable<PackResources> info) {
        ResourcePackSourceTracker.setSource((PackResources)info.getReturnValue(), this.location().source());
    }

    @Override
    public boolean fabric_isHidden() {
        return this.parentsPredicate != DEFAULT_PARENT_PREDICATE;
    }

    @Override
    public boolean fabric_parentsEnabled(Set<String> enabled) {
        return this.parentsPredicate.test(enabled);
    }

    @Override
    public void fabric_setParentsPredicate(Predicate<Set<String>> predicate) {
        this.parentsPredicate = predicate;
    }
}

