/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;

public class ResourceManagerHelperImpl
implements ResourceManagerHelper {
    private static final Map<PackType, ResourceManagerHelperImpl> registryMap = new HashMap<PackType, ResourceManagerHelperImpl>();
    private final ResourceLoader resourceLoader;

    private ResourceManagerHelperImpl(PackType type) {
        this.resourceLoader = ResourceLoader.get((PackType)type);
    }

    public static ResourceManagerHelperImpl get(PackType type) {
        return registryMap.computeIfAbsent(type, ResourceManagerHelperImpl::new);
    }

    @Override
    public void registerReloadListener(IdentifiableResourceReloadListener listener) {
        this.resourceLoader.registerReloader(listener.getFabricId(), (PreparableReloadListener)listener);
        listener.getFabricDependencies().forEach(dependency -> this.resourceLoader.addReloaderOrdering(dependency, listener.getFabricId()));
    }

    @Override
    public void registerReloadListener(Identifier identifier, final Function<HolderLookup.Provider, IdentifiableResourceReloadListener> listenerFactory) {
        this.resourceLoader.registerReloader(identifier, new PreparableReloadListener(){

            public CompletableFuture<Void> reload(PreparableReloadListener.SharedState store, Executor prepareExecutor, PreparableReloadListener.PreparationBarrier reloadSynchronizer, Executor applyExecutor) {
                HolderLookup.Provider registries = (HolderLookup.Provider)store.get(ResourceLoader.RELOADER_REGISTRY_LOOKUP_KEY);
                PreparableReloadListener resourceReloader = (PreparableReloadListener)listenerFactory.apply(registries);
                return resourceReloader.reload(store, prepareExecutor, reloadSynchronizer, applyExecutor);
            }
        });
    }
}

