/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.v1.client;

import java.util.Locale;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import net.fabricmc.fabric.api.resource.v1.reloader.ResourceReloaderKeys;
import net.fabricmc.fabric.impl.resource.v1.FabricResourceReloader;
import net.minecraft.class_10151;
import net.minecraft.class_10201;
import net.minecraft.class_1060;
import net.minecraft.class_1069;
import net.minecraft.class_1070;
import net.minecraft.class_1076;
import net.minecraft.class_10831;
import net.minecraft.class_1092;
import net.minecraft.class_11327;
import net.minecraft.class_1144;
import net.minecraft.class_11697;
import net.minecraft.class_11939;
import net.minecraft.class_2960;
import net.minecraft.class_378;
import net.minecraft.class_4008;
import net.minecraft.class_5407;
import net.minecraft.class_6877;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_898;
import net.minecraft.class_9955;

@Mixin({
		/* public */
		class_11697.class,
		class_1092.class,
		class_824.class,
		class_776.class,
		class_9955.class,
		class_10201.class,
		class_898.class,
		class_10831.class,
		class_1070.class,
		class_378.class,
		class_1069.class,
		class_1076.class,
		class_11939.class,
		class_10151.class,
		class_4008.class,
		class_1144.class,
		class_1060.class,
		class_11327.class,
		/* private */
		class_761.class, class_5407.class, class_6877.class
})
public abstract class KeyedClientResourceReloadListenerMixin implements FabricResourceReloader {
	@Unique
	private class_2960 id;

	@Override
	public class_2960 fabric$getId() {
		if (this.id == null) {
			Object self = this;

			if (self instanceof class_11697) {
				this.id = ResourceReloaderKeys.Client.ATLAS;
			} else if (self instanceof class_1092) {
				this.id = ResourceReloaderKeys.Client.MODELS;
			} else if (self instanceof class_824) {
				this.id = ResourceReloaderKeys.Client.BLOCK_ENTITY_RENDERERS;
			} else if (self instanceof class_776) {
				this.id = ResourceReloaderKeys.Client.BLOCK_RENDER_MANAGER;
			} else if (self instanceof class_9955) {
				this.id = ResourceReloaderKeys.Client.CLOUD_CELLS;
			} else if (self instanceof class_10831) {
				this.id = ResourceReloaderKeys.Client.DRY_FOLIAGE_COLORMAP;
			} else if (self instanceof class_10201) {
				this.id = ResourceReloaderKeys.Client.EQUIPMENT_MODELS;
			} else if (self instanceof class_898) {
				this.id = ResourceReloaderKeys.Client.ENTITY_RENDERERS;
			} else if (self instanceof class_378) {
				this.id = ResourceReloaderKeys.Client.FONTS;
			} else if (self instanceof class_1070) {
				this.id = ResourceReloaderKeys.Client.FOLIAGE_COLORMAP;
			} else if (self instanceof class_1069) {
				this.id = ResourceReloaderKeys.Client.GRASS_COLORMAP;
			} else if (self instanceof class_1076) {
				this.id = ResourceReloaderKeys.Client.LANGUAGES;
			} else if (self instanceof class_11939) {
				this.id = ResourceReloaderKeys.Client.PARTICLES;
			} else if (self instanceof class_10151) {
				this.id = ResourceReloaderKeys.Client.SHADERS;
			} else if (self instanceof class_4008) {
				this.id = ResourceReloaderKeys.Client.SPLASH_TEXTS;
			} else if (self instanceof class_1144) {
				this.id = ResourceReloaderKeys.Client.SOUNDS;
			} else if (self instanceof class_1060) {
				this.id = ResourceReloaderKeys.Client.TEXTURES;
			} else if (self instanceof class_11327) {
				this.id = ResourceReloaderKeys.Client.WAYPOINT_STYLE_ASSETS;
			} else {
				this.id = class_2960.method_60656("private/" + self.getClass().getSimpleName().toLowerCase(Locale.ROOT));
			}
		}

		return this.id;
	}
}
