/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.resource.pack;

import java.util.ArrayList;
import net.fabricmc.fabric.api.resource.v1.pack.ModPackResources;
import net.minecraft.class_3262;
import net.minecraft.class_3288;
import net.minecraft.class_8614;
import net.minecraft.class_9224;

public record ModPackResourcesFactory(ModPackResources pack) implements class_3288.class_7680 {
	@Override
	public class_3262 method_52424(class_9224 location) {
		return this.pack;
	}

	@Override
	public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
		if (metadata.comp_1584().isEmpty()) {
			return this.pack;
		} else {
			var overlays = new ArrayList<class_3262>(metadata.comp_1584().size());

			for (String overlay : metadata.comp_1584()) {
				overlays.add(this.pack.createOverlay(overlay));
			}

			return new class_8614(this.pack, overlays);
		}
	}
}
