/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.api.resource.v1.pack.PackActivationType;
import net.fabricmc.fabric.api.resource.v1.reloader.ResourceReloaderKeys;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.base.toposort.NodeSorting;
import net.fabricmc.fabric.impl.base.toposort.SortableNode;
import net.fabricmc.fabric.impl.resource.DataResourceLoaderImpl;
import net.fabricmc.fabric.impl.resource.FabricResourceReloader;
import net.fabricmc.fabric.impl.resource.ResourceReloaderPhaseData;
import net.fabricmc.fabric.impl.resource.SetupMarkerResourceReloader;
import net.fabricmc.fabric.impl.resource.pack.BuiltinModResourcePackSource;
import net.fabricmc.fabric.impl.resource.pack.ModNioPackResources;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3302;
import net.minecraft.class_5352;
import net.minecraft.class_8614;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public sealed class ResourceLoaderImpl
implements ResourceLoader
permits DataResourceLoaderImpl {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<class_3264, ResourceLoaderImpl> IMPL_MAP = new EnumMap<class_3264, ResourceLoaderImpl>(class_3264.class);
    private static final Set<BuiltinPackResourcesEntry> BUILTIN_PACK_RESOURCES = new HashSet<BuiltinPackResourcesEntry>();
    private static final boolean DEBUG_RELOADERS_IDENTITY = TriState.fromSystemProperty((String)"fabric.resource_loader.debug.reloaders_identity").orElse(FabricLoader.getInstance().isDevelopmentEnvironment());
    public static final boolean DEBUG_PROFILE_RESOURCE_RELOADERS = Boolean.getBoolean("fabric.resource_loader.debug.profile_resource_reloaders");
    private static final boolean DEBUG_RELOADERS_ORDER = Boolean.getBoolean("fabric.resource_loader.debug.reloaders_order");
    private final Map<class_2960, class_3302> addedReloaders = new LinkedHashMap<class_2960, class_3302>();
    private final Set<ReloaderOrder> reloadersOrdering = new LinkedHashSet<ReloaderOrder>();
    private final class_3264 type;

    public static ResourceLoaderImpl get(class_3264 type) {
        return IMPL_MAP.computeIfAbsent(type, target -> target == class_3264.field_14190 ? DataResourceLoaderImpl.INSTANCE : new ResourceLoaderImpl(type));
    }

    ResourceLoaderImpl(class_3264 type) {
        this.type = type;
    }

    protected boolean hasResourceReloader(class_2960 id) {
        return this.addedReloaders.containsKey(id);
    }

    protected final void checkUniqueResourceReloader(class_2960 id) {
        if (this.hasResourceReloader(id)) {
            throw new IllegalStateException("Tried to register resource reloader %s twice!".formatted(id));
        }
    }

    @Override
    public void registerReloader(class_2960 id, class_3302 reloader) {
        Objects.requireNonNull(id, "The reloader identifier should not be null.");
        Objects.requireNonNull(reloader, "The reloader should not be null.");
        this.checkUniqueResourceReloader(id);
        for (Map.Entry<class_2960, class_3302> entry : this.addedReloaders.entrySet()) {
            if (entry.getValue() != reloader) continue;
            throw new IllegalStateException("Resource reloader with ID %s already in resource reloader set with ID %s!".formatted(id, entry.getKey()));
        }
        this.addedReloaders.put(id, reloader);
    }

    @Override
    public void addReloaderOrdering(class_2960 firstReloader, class_2960 secondReloader) {
        Objects.requireNonNull(firstReloader, "The first reloader identifier should not be null.");
        Objects.requireNonNull(secondReloader, "The second reloader identifier should not be null.");
        if (firstReloader.equals((Object)secondReloader)) {
            throw new IllegalArgumentException("Tried to add a phase that depends on itself.");
        }
        this.reloadersOrdering.add(new ReloaderOrder(firstReloader, secondReloader));
    }

    private class_2960 getResourceReloaderIdForSorting(class_3302 reloader) {
        if (reloader instanceof FabricResourceReloader) {
            FabricResourceReloader identifiable = (FabricResourceReloader)reloader;
            return identifiable.fabric$getId();
        }
        if (DEBUG_RELOADERS_IDENTITY) {
            LOGGER.warn("The resource reloader at {} does not use identifiable registration making ordering support more difficult for other modders.", (Object)reloader.getClass().getName());
        }
        return class_2960.method_60655((String)"unknown", (String)("private/" + reloader.getClass().getName().replace(".", "/").replace("$", "_").toLowerCase(Locale.ROOT)));
    }

    public static List<class_3302> sort(class_3264 type, List<class_3302> listeners) {
        if (type == null) {
            return listeners;
        }
        ResourceLoaderImpl instance = ResourceLoaderImpl.get(type);
        ArrayList<class_3302> mutable = new ArrayList<class_3302>(listeners);
        instance.sort(mutable);
        return Collections.unmodifiableList(mutable);
    }

    protected Set<Map.Entry<class_2960, class_3302>> collectReloadersToAdd(@Nullable SetupMarkerResourceReloader setupMarker) {
        return new LinkedHashSet<Map.Entry<class_2960, class_3302>>(this.addedReloaders.entrySet());
    }

    private void sort(List<class_3302> reloaders) {
        SetupMarkerResourceReloader setupReloader = this.extractSetupMarker(reloaders);
        Set<Map.Entry<class_2960, class_3302>> reloadersToAdd = this.collectReloadersToAdd(setupReloader);
        reloadersToAdd.stream().map(Map.Entry::getValue).forEach(reloaders::remove);
        Object2ObjectOpenHashMap runtimePhases = new Object2ObjectOpenHashMap();
        Iterator<class_3302> itPhases = reloaders.iterator();
        ResourceReloaderPhaseData last = new ResourceReloaderPhaseData(ResourceReloaderKeys.BEFORE_VANILLA, null);
        last.setVanillaStatus(ResourceReloaderPhaseData.VanillaStatus.VANILLA);
        runtimePhases.put((Object)last.id, (Object)last);
        while (itPhases.hasNext()) {
            class_3302 currentReloader = itPhases.next();
            class_2960 id = this.getResourceReloaderIdForSorting(currentReloader);
            ResourceReloaderPhaseData resourceReloaderPhaseData = new ResourceReloaderPhaseData(id, currentReloader);
            resourceReloaderPhaseData.setVanillaStatus(ResourceReloaderPhaseData.VanillaStatus.VANILLA);
            runtimePhases.put((Object)id, (Object)resourceReloaderPhaseData);
            SortableNode.link((SortableNode)last, (SortableNode)resourceReloaderPhaseData);
            last = resourceReloaderPhaseData;
        }
        ResourceReloaderPhaseData.AfterVanilla afterVanilla = new ResourceReloaderPhaseData.AfterVanilla(ResourceReloaderKeys.AFTER_VANILLA);
        runtimePhases.put((Object)afterVanilla.id, (Object)afterVanilla);
        SortableNode.link((SortableNode)last, (SortableNode)afterVanilla);
        for (Map.Entry entry : reloadersToAdd) {
            ResourceReloaderPhaseData phase = new ResourceReloaderPhaseData((class_2960)entry.getKey(), (class_3302)entry.getValue());
            runtimePhases.put((Object)phase.id, (Object)phase);
        }
        for (ReloaderOrder reloaderOrder : this.reloadersOrdering) {
            ResourceReloaderPhaseData second;
            ResourceReloaderPhaseData first = (ResourceReloaderPhaseData)((Object)runtimePhases.get((Object)reloaderOrder.first));
            if (first == null || (second = (ResourceReloaderPhaseData)((Object)runtimePhases.get((Object)reloaderOrder.second))) == null) continue;
            SortableNode.link((SortableNode)first, (SortableNode)second);
        }
        for (ResourceReloaderPhaseData resourceReloaderPhaseData : runtimePhases.values()) {
            if (resourceReloaderPhaseData == afterVanilla || resourceReloaderPhaseData.vanillaStatus != ResourceReloaderPhaseData.VanillaStatus.NONE && resourceReloaderPhaseData.vanillaStatus != ResourceReloaderPhaseData.VanillaStatus.AFTER) continue;
            SortableNode.link((SortableNode)afterVanilla, (SortableNode)resourceReloaderPhaseData);
        }
        ArrayList phases = new ArrayList(runtimePhases.values());
        NodeSorting.sort(phases, (String)"resource reloaders", Comparator.comparing(data -> data.id));
        reloaders.clear();
        if (setupReloader != null) {
            reloaders.add((class_3302)setupReloader);
        }
        for (ResourceReloaderPhaseData phase : phases) {
            if (phase.resourceReloader == null) continue;
            reloaders.add(phase.resourceReloader);
        }
        if (DEBUG_RELOADERS_ORDER) {
            LOGGER.info("Sorted reloaders: {}", (Object)phases.stream().map(data -> {
                Object str = data.id.toString();
                if (data.resourceReloader == null) {
                    str = (String)str + " (virtual)";
                }
                return str;
            }).collect(Collectors.joining(", ")));
        }
    }

    private @Nullable SetupMarkerResourceReloader extractSetupMarker(List<class_3302> reloaders) {
        if (this.type == class_3264.field_14188) {
            return null;
        }
        Iterator<class_3302> it = reloaders.iterator();
        while (it.hasNext()) {
            class_3302 class_33022 = it.next();
            if (!(class_33022 instanceof SetupMarkerResourceReloader)) continue;
            SetupMarkerResourceReloader marker = (SetupMarkerResourceReloader)class_33022;
            it.remove();
            return marker;
        }
        throw new IllegalStateException("No SetupMarkerResourceReloader found in reloaders!");
    }

    public static boolean registerBuiltinPack(class_2960 id, String subPath, ModContainer container, class_2561 displayName, PackActivationType activationType) {
        List paths = container.getRootPaths();
        String separator = ((Path)paths.getFirst()).getFileSystem().getSeparator();
        subPath = subPath.replace("/", separator);
        ModNioPackResources resourcePack = ModNioPackResources.create(id.toString(), container, subPath, class_3264.field_14188, activationType, false);
        ModNioPackResources dataPack = ModNioPackResources.create(id.toString(), container, subPath, class_3264.field_14190, activationType, false);
        if (resourcePack == null && dataPack == null) {
            return false;
        }
        if (resourcePack != null) {
            BUILTIN_PACK_RESOURCES.add(new BuiltinPackResourcesEntry(displayName, resourcePack));
        }
        if (dataPack != null) {
            BUILTIN_PACK_RESOURCES.add(new BuiltinPackResourcesEntry(displayName, dataPack));
        }
        return true;
    }

    public static boolean registerBuiltinPack(class_2960 id, String subPath, ModContainer container, PackActivationType activationType) {
        return ResourceLoaderImpl.registerBuiltinPack(id, subPath, container, (class_2561)class_2561.method_43470((String)(id.method_12836() + "/" + id.method_12832())), activationType);
    }

    public static void registerBuiltinResourcePacks(class_3264 type, Consumer<class_3288> consumer) {
        for (BuiltinPackResourcesEntry entry : BUILTIN_PACK_RESOURCES) {
            final ModNioPackResources pack = entry.packResources();
            if (pack.method_14406(type).isEmpty()) continue;
            class_9224 info = new class_9224(pack.method_14409(), entry.displayName(), (class_5352)new BuiltinModResourcePackSource(pack.getFabricModMetadata().getName()), pack.method_56929());
            class_9225 selectionInfo = new class_9225(pack.getActivationType() == PackActivationType.ALWAYS_ENABLED, class_3288.class_3289.field_14280, false);
            class_3288 profile = class_3288.method_45275((class_9224)info, (class_3288.class_7680)new class_3288.class_7680(){

                public class_3262 method_52424(class_9224 location) {
                    return pack;
                }

                public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
                    if (metadata.comp_1584().isEmpty()) {
                        return pack;
                    }
                    ArrayList<ModNioPackResources> overlays = new ArrayList<ModNioPackResources>(metadata.comp_1584().size());
                    for (String overlay : metadata.comp_1584()) {
                        overlays.add(pack.createOverlay(overlay));
                    }
                    return new class_8614((class_3262)pack, overlays);
                }
            }, (class_3264)type, (class_9225)selectionInfo);
            consumer.accept(profile);
        }
    }

    private record ReloaderOrder(class_2960 first, class_2960 second) {
    }

    private record BuiltinPackResourcesEntry(class_2561 displayName, ModNioPackResources packResources) {
    }
}

