/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.client;

import java.util.List;
import java.util.Optional;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.resource.client.PackTooltipComponent;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_521;
import net.minecraft.class_5481;
import net.minecraft.class_7842;
import net.minecraft.class_7940;

@Mixin(class_521.class_4271.class)
class TransferableSelectionListPackEntryMixin {
	@Shadow
	@Final
	private static int MAX_DESCRIPTION_WIDTH_PIXELS;

	@Shadow
	@Final
	protected class_310 minecraft;

	@Shadow
	@Final
	private class_7842 nameWidget;

	@Shadow
	@Final
	private class_7940 descriptionWidget;

	@Shadow
	@Final
	class_521 field_62184;

	@Inject(method = "renderContent", at = @At("RETURN"))
	private void onRenderContent(
			class_332 graphics, int mouseX, int mouseY, boolean hovered, float tickDelta, CallbackInfo ci
	) {
		if (hovered) {
			class_2561 name = null;
			boolean includeDescription = false;

			if (this.nameWidget.method_25368() < this.minecraft.field_1772.method_30880(this.nameWidget.method_25369().method_30937())) {
				name = this.nameWidget.method_25369();
			}

			List<class_5481> splitDescription = this.minecraft.field_1772.method_1728(
					this.descriptionWidget.method_25369(),
					MAX_DESCRIPTION_WIDTH_PIXELS - (this.field_62184.method_44390() > 0 ? 6 : 0)
			);

			if (splitDescription.size() > 2) {
				includeDescription = true;
			}

			if (name != null || includeDescription) {
				graphics.method_64038(
						this.minecraft.field_1772,
						List.of(),
						Optional.of(new PackTooltipComponent(
								Optional.ofNullable(name),
								includeDescription ? Optional.of(splitDescription) : Optional.empty()
						)),
						mouseX, mouseY
				);
			}
		}
	}
}
