/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.resource.v1;

import java.util.function.Function;

import org.jetbrains.annotations.ApiStatus;
import net.fabricmc.fabric.impl.resource.DataResourceLoaderImpl;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_7225;

/**
 * Provides various hooks into the {@linkplain net.minecraft.class_3264#field_14190 server data} resource loader.
 */
@ApiStatus.NonExtendable
public interface DataResourceLoader extends ResourceLoader {
	/**
	 * The resource reloader store key for the recipe manager.
	 *
	 * @apiNote The recipe manager is only available in {@linkplain class_3264#field_14190 server data} resource reloaders.
	 * <br/>
	 * It should <b>only</b> be accessed in the application phase of the resource reloader,
	 * and you should depend on {@link net.fabricmc.fabric.api.resource.v1.reloader.ResourceReloaderKeys.Server#RECIPES}.
	 */
	class_3302.class_11559<class_1863> RECIPE_MANAGER_KEY = new class_3302.class_11559<>();
	/**
	 * The resource reloader store key for the advancement loader.
	 *
	 * @apiNote The advancement loader is only available in {@linkplain class_3264#field_14190 server data} resource reloaders.
	 * <br/>
	 * It should <b>only</b> be accessed in the application phase of the resource reloader,
	 * and you should depend on {@link net.fabricmc.fabric.api.resource.v1.reloader.ResourceReloaderKeys.Server#ADVANCEMENTS}.
	 */
	class_3302.class_11559<class_2989> ADVANCEMENT_LOADER_KEY = new class_3302.class_11559<>();
	/**
	 * The resource reloader store key for the data resource store.
	 *
	 * @apiNote The data resource store is only available in {@linkplain class_3264#field_14190 server data} resource reloaders.
	 * <br/>
	 * It should <b>only</b> be mutated in the application phase of the resource reloader.
	 */
	class_3302.class_11559<DataResourceStore.Mutable> DATA_RESOURCE_STORE_KEY = new class_3302.class_11559<>();

	static DataResourceLoader get() {
		return DataResourceLoaderImpl.INSTANCE;
	}

	/**
	 * Registers a data resource reloader.
	 *
	 * @param id the identifier of the resource reloader
	 * @param factory the factory function of the resource reloader
	 * @see #registerReloader(class_2960, class_3302)
	 * @see #addReloaderOrdering(class_2960, class_2960)
	 *
	 * @apiNote In most cases {@link #registerReloader(class_2960, class_3302)} is sufficient and should be preferred,
	 * but for some resource reloaders like {@link net.minecraft.class_4309} constructing the resource reloader
	 * with a known instance of the wrapper lookup is required.
	 * <br/>
	 * While this may encourage stateful resource reloaders, it is best to primarily use resource reloaders as stateless loaders,
	 * as storing a state may easily lead to incomplete or leaking data.
	 */
	void registerReloader(
			class_2960 id,
			Function<class_7225.class_7874, class_3302> factory
	);
}
