/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.resource.v1;

import net.minecraft.class_2960;
import net.minecraft.class_3302;

public interface FabricResourceReloader extends class_3302 {
	/**
	 * {@return the unique identifier of this Vanilla resource reloader}
	 */
	class_2960 fabric$getId();

	@Override
	default String method_22322() {
		// Give a more descriptive name to Vanilla resource reloaders
		// as in production their intermediary class names are not meaningful
		// when profiling.
		return this.fabric$getId() + " (" + this.getClass().getSimpleName() + ")";
	}
}
