/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.v1;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.api.resource.v1.reloader.ResourceReloaderKeys;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.base.toposort.NodeSorting;
import net.fabricmc.fabric.impl.base.toposort.SortableNode;
import net.fabricmc.fabric.impl.resource.v1.FabricRecipeManager;
import net.fabricmc.fabric.impl.resource.v1.FabricResourceReloader;
import net.fabricmc.fabric.impl.resource.v1.ResourceReloaderPhaseData;
import net.fabricmc.fabric.impl.resource.v1.SetupMarkerResourceReloader;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_7225;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class ResourceLoaderImpl
implements ResourceLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<class_3264, ResourceLoaderImpl> IMPL_MAP = new EnumMap<class_3264, ResourceLoaderImpl>(class_3264.class);
    private static final boolean DEBUG_RELOADERS_IDENTITY = TriState.fromSystemProperty((String)"fabric.resource_loader.debug.reloaders_identity").orElse(FabricLoader.getInstance().isDevelopmentEnvironment());
    public static final boolean DEBUG_PROFILE_RESOURCE_RELOADERS = Boolean.getBoolean("fabric.resource_loader.debug.profile_resource_reloaders");
    private static final boolean DEBUG_RELOADERS_ORDER = Boolean.getBoolean("fabric.resource_loader.debug.reloaders_order");
    private final Map<class_2960, class_3302> addedReloaders = new LinkedHashMap<class_2960, class_3302>();
    private final Set<ReloaderOrder> reloadersOrdering = new LinkedHashSet<ReloaderOrder>();
    private final class_3264 type;

    public static ResourceLoaderImpl get(class_3264 type) {
        return IMPL_MAP.computeIfAbsent(type, ResourceLoaderImpl::new);
    }

    private ResourceLoaderImpl(class_3264 type) {
        this.type = type;
    }

    @Override
    public void registerReloader(class_2960 id, class_3302 reloader) {
        Objects.requireNonNull(id, "The reloader identifier should not be null.");
        Objects.requireNonNull(reloader, "The reloader should not be null.");
        if (this.addedReloaders.containsKey(id)) {
            throw new IllegalStateException("Tried to register resource reloader %s twice!".formatted(id));
        }
        for (Map.Entry<class_2960, class_3302> entry : this.addedReloaders.entrySet()) {
            if (entry.getValue() != reloader) continue;
            throw new IllegalStateException("Resource reloader with ID %s already in resource reloader set with ID %s!".formatted(id, entry.getKey()));
        }
        this.addedReloaders.put(id, reloader);
    }

    @Override
    public void addReloaderOrdering(class_2960 firstReloader, class_2960 secondReloader) {
        Objects.requireNonNull(firstReloader, "The first reloader identifier should not be null.");
        Objects.requireNonNull(secondReloader, "The second reloader identifier should not be null.");
        if (firstReloader.equals((Object)secondReloader)) {
            throw new IllegalArgumentException("Tried to add a phase that depends on itself.");
        }
        this.reloadersOrdering.add(new ReloaderOrder(firstReloader, secondReloader));
    }

    private class_2960 getResourceReloaderIdForSorting(class_3302 reloader) {
        if (reloader instanceof FabricResourceReloader) {
            FabricResourceReloader identifiable = (FabricResourceReloader)reloader;
            return identifiable.fabric$getId();
        }
        if (DEBUG_RELOADERS_IDENTITY) {
            LOGGER.warn("The resource reloader at {} does not implement IdentifiableResourceReloader making ordering support more difficult for other modders.", (Object)reloader.getClass().getName());
        }
        return class_2960.method_60655((String)"unknown", (String)("private/" + reloader.getClass().getName().replace(".", "/").replace("$", "_").toLowerCase(Locale.ROOT)));
    }

    public static List<class_3302> sort(class_3264 type, List<class_3302> listeners) {
        if (type == null) {
            return listeners;
        }
        ResourceLoaderImpl instance = ResourceLoaderImpl.get(type);
        ArrayList<class_3302> mutable = new ArrayList<class_3302>(listeners);
        instance.sort(mutable);
        return Collections.unmodifiableList(mutable);
    }

    private void sort(List<class_3302> reloaders) {
        LinkedHashSet<Map.Entry<class_2960, class_3302>> reloadersToAdd = new LinkedHashSet<Map.Entry<class_2960, class_3302>>(this.addedReloaders.entrySet());
        class_3302 setupReloader = this.extractSetupMarker(reloaders);
        reloadersToAdd.stream().map(Map.Entry::getValue).forEach(reloaders::remove);
        Object2ObjectOpenHashMap runtimePhases = new Object2ObjectOpenHashMap();
        Iterator<class_3302> itPhases = reloaders.iterator();
        ResourceReloaderPhaseData last = new ResourceReloaderPhaseData(ResourceReloaderKeys.BEFORE_VANILLA, null);
        last.setVanillaStatus(ResourceReloaderPhaseData.VanillaStatus.VANILLA);
        runtimePhases.put((Object)last.id, (Object)last);
        while (itPhases.hasNext()) {
            class_3302 currentReloader = itPhases.next();
            class_2960 id = this.getResourceReloaderIdForSorting(currentReloader);
            ResourceReloaderPhaseData resourceReloaderPhaseData = new ResourceReloaderPhaseData(id, currentReloader);
            resourceReloaderPhaseData.setVanillaStatus(ResourceReloaderPhaseData.VanillaStatus.VANILLA);
            runtimePhases.put((Object)id, (Object)resourceReloaderPhaseData);
            SortableNode.link((SortableNode)last, (SortableNode)resourceReloaderPhaseData);
            last = resourceReloaderPhaseData;
        }
        ResourceReloaderPhaseData.AfterVanilla afterVanilla = new ResourceReloaderPhaseData.AfterVanilla(ResourceReloaderKeys.AFTER_VANILLA);
        runtimePhases.put((Object)afterVanilla.id, (Object)afterVanilla);
        SortableNode.link((SortableNode)last, (SortableNode)afterVanilla);
        for (Map.Entry entry : reloadersToAdd) {
            ResourceReloaderPhaseData phase = new ResourceReloaderPhaseData((class_2960)entry.getKey(), (class_3302)entry.getValue());
            runtimePhases.put((Object)phase.id, (Object)phase);
        }
        for (ReloaderOrder reloaderOrder : this.reloadersOrdering) {
            ResourceReloaderPhaseData second;
            ResourceReloaderPhaseData first = (ResourceReloaderPhaseData)((Object)runtimePhases.get((Object)reloaderOrder.first));
            if (first == null || (second = (ResourceReloaderPhaseData)((Object)runtimePhases.get((Object)reloaderOrder.second))) == null) continue;
            SortableNode.link((SortableNode)first, (SortableNode)second);
        }
        for (ResourceReloaderPhaseData resourceReloaderPhaseData : runtimePhases.values()) {
            if (resourceReloaderPhaseData == afterVanilla || resourceReloaderPhaseData.vanillaStatus != ResourceReloaderPhaseData.VanillaStatus.NONE && resourceReloaderPhaseData.vanillaStatus != ResourceReloaderPhaseData.VanillaStatus.AFTER) continue;
            SortableNode.link((SortableNode)afterVanilla, (SortableNode)resourceReloaderPhaseData);
        }
        ArrayList phases = new ArrayList(runtimePhases.values());
        NodeSorting.sort(phases, (String)"resource reloaders", Comparator.comparing(data -> data.id));
        reloaders.clear();
        if (setupReloader != null) {
            reloaders.add(setupReloader);
        }
        for (ResourceReloaderPhaseData phase : phases) {
            if (phase.resourceReloader == null) continue;
            reloaders.add(phase.resourceReloader);
        }
        if (DEBUG_RELOADERS_ORDER) {
            LOGGER.info("Sorted reloaders: {}", (Object)phases.stream().map(data -> {
                Object str = data.id.toString();
                if (data.resourceReloader == null) {
                    str = (String)str + " (virtual)";
                }
                return str;
            }).collect(Collectors.joining(", ")));
        }
    }

    private @Nullable class_3302 extractSetupMarker(List<class_3302> reloaders) {
        if (this.type == class_3264.field_14188) {
            return null;
        }
        Iterator<class_3302> it = reloaders.iterator();
        while (it.hasNext()) {
            class_3302 class_33022 = it.next();
            if (!(class_33022 instanceof SetupMarkerResourceReloader)) continue;
            SetupMarkerResourceReloader marker = (SetupMarkerResourceReloader)class_33022;
            it.remove();
            return marker;
        }
        throw new IllegalStateException("No SetupMarkerResourceReloader found in reloaders!");
    }

    public static class_7225.class_7874 getWrapperLookup(List<class_3302> reloaders) {
        for (class_3302 resourceReloader : reloaders) {
            if (!(resourceReloader instanceof FabricRecipeManager)) continue;
            FabricRecipeManager recipeManager = (FabricRecipeManager)resourceReloader;
            return recipeManager.fabric$getRegistries();
        }
        throw new IllegalStateException("No ServerRecipeManager found in reloaders!");
    }

    private record ReloaderOrder(class_2960 first, class_2960 second) {
    }
}

