/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.screen;

import java.util.List;

import org.jetbrains.annotations.ApiStatus;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_339;
import net.minecraft.class_437;

@ApiStatus.Internal
@Environment(EnvType.CLIENT)
public interface ScreenExtensions {
	static ScreenExtensions getExtensions(class_437 screen) {
		return (ScreenExtensions) screen;
	}

	List<class_339> fabric_getButtons();

	Event<ScreenEvents.Remove> fabric_getRemoveEvent();

	Event<ScreenEvents.BeforeTick> fabric_getBeforeTickEvent();

	Event<ScreenEvents.AfterTick> fabric_getAfterTickEvent();

	Event<ScreenEvents.BeforeRender> fabric_getBeforeRenderEvent();

	Event<ScreenEvents.AfterRender> fabric_getAfterRenderEvent();

	// Keyboard

	Event<ScreenKeyboardEvents.AllowKeyPress> fabric_getAllowKeyPressEvent();

	Event<ScreenKeyboardEvents.BeforeKeyPress> fabric_getBeforeKeyPressEvent();

	Event<ScreenKeyboardEvents.AfterKeyPress> fabric_getAfterKeyPressEvent();

	Event<ScreenKeyboardEvents.AllowKeyRelease> fabric_getAllowKeyReleaseEvent();

	Event<ScreenKeyboardEvents.BeforeKeyRelease> fabric_getBeforeKeyReleaseEvent();

	Event<ScreenKeyboardEvents.AfterKeyRelease> fabric_getAfterKeyReleaseEvent();

	// Mouse

	Event<ScreenMouseEvents.AllowMouseClick> fabric_getAllowMouseClickEvent();

	Event<ScreenMouseEvents.BeforeMouseClick> fabric_getBeforeMouseClickEvent();

	Event<ScreenMouseEvents.AfterMouseClick> fabric_getAfterMouseClickEvent();

	Event<ScreenMouseEvents.AllowMouseRelease> fabric_getAllowMouseReleaseEvent();

	Event<ScreenMouseEvents.BeforeMouseRelease> fabric_getBeforeMouseReleaseEvent();

	Event<ScreenMouseEvents.AfterMouseRelease> fabric_getAfterMouseReleaseEvent();

	Event<ScreenMouseEvents.AllowMouseScroll> fabric_getAllowMouseScrollEvent();

	Event<ScreenMouseEvents.BeforeMouseScroll> fabric_getBeforeMouseScrollEvent();

	Event<ScreenMouseEvents.AfterMouseScroll> fabric_getAfterMouseScrollEvent();
}

