/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.screen;

import java.util.AbstractList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;

@Environment(value=EnvType.CLIENT)
public final class ButtonList
extends AbstractList<class_339> {
    private final List<class_4068> drawables;
    private final List<class_6379> selectables;
    private final List<class_364> children;

    public ButtonList(List<class_4068> drawables, List<class_6379> selectables, List<class_364> children) {
        this.drawables = drawables;
        this.selectables = selectables;
        this.children = children;
    }

    @Override
    public class_339 get(int index) {
        int drawableIndex = this.translateIndex(this.drawables, index, false);
        return (class_339)this.drawables.get(drawableIndex);
    }

    @Override
    public class_339 set(int index, class_339 element) {
        int drawableIndex = this.translateIndex(this.drawables, index, false);
        this.drawables.set(drawableIndex, (class_4068)element);
        int selectableIndex = this.translateIndex(this.selectables, index, false);
        this.selectables.set(selectableIndex, (class_6379)element);
        int childIndex = this.translateIndex(this.children, index, false);
        return (class_339)this.children.set(childIndex, (class_364)element);
    }

    @Override
    public void add(int index, class_339 element) {
        int duplicateIndex = this.drawables.indexOf(element);
        if (duplicateIndex >= 0) {
            this.drawables.remove(element);
            this.selectables.remove(element);
            this.children.remove(element);
            if (duplicateIndex <= this.translateIndex(this.drawables, index, true)) {
                --index;
            }
        }
        int drawableIndex = this.translateIndex(this.drawables, index, true);
        this.drawables.add(drawableIndex, (class_4068)element);
        int selectableIndex = this.translateIndex(this.selectables, index, true);
        this.selectables.add(selectableIndex, (class_6379)element);
        int childIndex = this.translateIndex(this.children, index, true);
        this.children.add(childIndex, (class_364)element);
    }

    @Override
    public class_339 remove(int index) {
        index = this.translateIndex(this.drawables, index, false);
        class_339 removedButton = (class_339)this.drawables.remove(index);
        this.selectables.remove(removedButton);
        this.children.remove(removedButton);
        return removedButton;
    }

    @Override
    public int size() {
        int ret = 0;
        for (class_4068 drawable : this.drawables) {
            if (!(drawable instanceof class_339)) continue;
            ++ret;
        }
        return ret;
    }

    private int translateIndex(List<?> list, int index, boolean allowAfter) {
        int remaining = index;
        int max = list.size();
        for (int i = 0; i < max; ++i) {
            if (!(list.get(i) instanceof class_339)) continue;
            if (remaining == 0) {
                return i;
            }
            --remaining;
        }
        if (allowAfter && remaining == 0) {
            return list.size();
        }
        throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, index - remaining));
    }
}

