/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.screenhandler;

import java.util.OptionalInt;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.impl.screenhandler.ExtendedScreenHandlerType;
import net.fabricmc.fabric.impl.screenhandler.Networking;
import net.minecraft.class_1703;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3908;

@Mixin(class_3222.class)
public class ServerPlayerEntityMixin {
	@Shadow
	private int screenHandlerSyncId;

	@Unique
	private final ThreadLocal<class_1703> fabric_openedScreenHandler = new ThreadLocal<>();

	@Inject(method = "openHandledScreen(Lnet/minecraft/screen/NamedScreenHandlerFactory;)Ljava/util/OptionalInt;", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/Packet;)V"), locals = LocalCapture.CAPTURE_FAILHARD)
	private void fabric_storeOpenedScreenHandler(class_3908 factory, CallbackInfoReturnable<OptionalInt> info, class_1703 handler) {
		if (factory instanceof ExtendedScreenHandlerFactory) {
			fabric_openedScreenHandler.set(handler);
		} else if (handler.method_17358() instanceof ExtendedScreenHandlerType<?>) {
			class_2960 id = class_2378.field_17429.method_10221(handler.method_17358());
			throw new IllegalArgumentException("[Fabric] Extended screen handler " + id + " must be opened with an ExtendedScreenHandlerFactory!");
		}
	}

	@Redirect(method = "openHandledScreen(Lnet/minecraft/screen/NamedScreenHandlerFactory;)Ljava/util/OptionalInt;", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/Packet;)V"))
	private void fabric_replaceVanillaScreenPacket(class_3244 networkHandler, class_2596<?> packet, class_3908 factory) {
		if (factory instanceof ExtendedScreenHandlerFactory) {
			class_1703 handler = fabric_openedScreenHandler.get();

			if (handler.method_17358() instanceof ExtendedScreenHandlerType<?>) {
				Networking.sendOpenPacket((class_3222) (Object) this, (ExtendedScreenHandlerFactory) factory, handler, screenHandlerSyncId);
			} else {
				class_2960 id = class_2378.field_17429.method_10221(handler.method_17358());
				throw new IllegalArgumentException("[Fabric] Non-extended screen handler " + id + " must not be opened with an ExtendedScreenHandlerFactory!");
			}
		} else {
			// Use vanilla logic for non-extended screen handlers
			networkHandler.method_14364(packet);
		}
	}

	@Inject(method = "openHandledScreen(Lnet/minecraft/screen/NamedScreenHandlerFactory;)Ljava/util/OptionalInt;", at = @At("RETURN"))
	private void fabric_clearStoredScreenHandler(class_3908 factory, CallbackInfoReturnable<OptionalInt> info) {
		fabric_openedScreenHandler.remove();
	}
}
