/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.screenhandler;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.OptionalInt;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.impl.screenhandler.Networking;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Shadow
    private int containerCounter;

    private ServerPlayerMixin(Level world, GameProfile gameProfile) {
        super(world, gameProfile);
    }

    @Shadow
    public abstract void closeContainer();

    @Redirect(method={"openMenu(Lnet/minecraft/world/MenuProvider;)Ljava/util/OptionalInt;"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;closeContainer()V"))
    private void fabric_closeHandledScreenIfAllowed(ServerPlayer player, MenuProvider factory) {
        if (factory.shouldCloseCurrentScreen()) {
            this.closeContainer();
        } else {
            this.doCloseContainer();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"openMenu(Lnet/minecraft/world/MenuProvider;)Ljava/util/OptionalInt;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V")})
    private void fabric_storeOpenedScreenHandler(MenuProvider factory, CallbackInfoReturnable<OptionalInt> info, @Local AbstractContainerMenu handler) {
        block3: {
            block2: {
                if (factory instanceof ExtendedScreenHandlerFactory) break block2;
                if (!(factory instanceof SimpleMenuProvider)) break block3;
                SimpleMenuProvider simpleFactory = (SimpleMenuProvider)factory;
                if (!(simpleFactory.menuConstructor instanceof ExtendedScreenHandlerFactory)) break block3;
            }
            this.containerMenu = handler;
            return;
        }
        if (!(handler.getType() instanceof ExtendedScreenHandlerType)) return;
        Identifier id = BuiltInRegistries.MENU.getKey((Object)handler.getType());
        throw new IllegalArgumentException("[Fabric] Extended screen handler " + String.valueOf(id) + " must be opened with an ExtendedScreenHandlerFactory!");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Redirect(method={"openMenu(Lnet/minecraft/world/MenuProvider;)Ljava/util/OptionalInt;"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private void fabric_replaceVanillaScreenPacket(ServerGamePacketListenerImpl networkHandler, Packet<?> packet, MenuProvider factory) {
        if (factory instanceof SimpleMenuProvider) {
            SimpleMenuProvider simpleFactory = (SimpleMenuProvider)factory;
            MenuConstructor menuConstructor = simpleFactory.menuConstructor;
            if (menuConstructor instanceof ExtendedScreenHandlerFactory) {
                ExtendedScreenHandlerFactory extendedFactory = (ExtendedScreenHandlerFactory)menuConstructor;
                factory = extendedFactory;
            }
        }
        if (!(factory instanceof ExtendedScreenHandlerFactory)) {
            networkHandler.send(packet);
            return;
        }
        ExtendedScreenHandlerFactory extendedFactory = (ExtendedScreenHandlerFactory)factory;
        AbstractContainerMenu handler = Objects.requireNonNull(this.containerMenu);
        if (handler.getType() instanceof ExtendedScreenHandlerType) {
            Networking.sendOpenPacket((ServerPlayer)this, extendedFactory, handler, this.containerCounter);
            return;
        }
        Identifier id = BuiltInRegistries.MENU.getKey((Object)handler.getType());
        throw new IllegalArgumentException("[Fabric] Non-extended screen handler " + String.valueOf(id) + " must not be opened with an ExtendedScreenHandlerFactory!");
    }
}

