/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.serialization;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.api.serialization.v1.view.FabricWriteView;
import net.minecraft.class_11362;
import net.minecraft.class_2487;

@Mixin(class_11362.class)
public class TagValueOutputMixin implements FabricWriteView {
	@Shadow
	@Final
	private class_2487 output;

	@Override
	public void putByteArray(String key, byte[] value) {
		this.output.method_10570(key, value);
	}

	@Override
	public void putLongArray(String key, long[] value) {
		this.output.method_10564(key, value);
	}
}
