/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.serialization.v1.view;

import net.fabricmc.fabric.impl.serialization.SpecialCodecs;
import net.minecraft.class_11372;

/**
 * Fabric provided extension of WriteView.
 *
 * <p>Note: This interface is automatically implemented on {@link class_11372} via Mixin and interface injection.
 */
public interface FabricWriteView {
	default void putLongArray(String key, long[] value) {
		((class_11372) this).method_71468(key, SpecialCodecs.LONG_ARRAY, value);
	}

	default void putByteArray(String key, byte[] value) {
		((class_11372) this).method_71468(key, SpecialCodecs.BYTE_ARRAY, value);
	}
}
