/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.structure.v1;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.impl.structure.FabricStructureUtil;
import net.fabricmc.fabric.impl.structure.StructuresConfigHooks;
import net.fabricmc.fabric.mixin.structure.BiomeAccessor;
import net.fabricmc.fabric.mixin.structure.FlatChunkGeneratorConfigAccessor;
import net.fabricmc.fabric.mixin.structure.StructureFeatureAccessor;
import net.fabricmc.fabric.mixin.structure.StructuresConfigAccessor;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_5311;
import net.minecraft.class_5312;
import net.minecraft.class_5314;
import net.minecraft.class_5458;

public final class FabricStructureBuilder<FC extends class_3037, S extends class_3195<FC>> {
    private final class_2960 id;
    private final S structure;
    private class_2893.class_2895 step;
    private class_5314 defaultConfig;
    private class_5312<FC, ? extends class_3195<FC>> superflatFeature;
    private boolean adjustsSurface = false;

    private FabricStructureBuilder(class_2960 id, S structure) {
        this.id = id;
        this.structure = structure;
    }

    public static <FC extends class_3037, S extends class_3195<FC>> FabricStructureBuilder<FC, S> create(class_2960 id, S structure) {
        Objects.requireNonNull(id, "id must not be null");
        Objects.requireNonNull(structure, "structure must not be null");
        return new FabricStructureBuilder<FC, S>(id, structure);
    }

    public FabricStructureBuilder<FC, S> step(class_2893.class_2895 step) {
        Objects.requireNonNull(step, "step must not be null");
        this.step = step;
        return this;
    }

    public FabricStructureBuilder<FC, S> defaultConfig(class_5314 config) {
        Objects.requireNonNull(config, "config must not be null");
        this.defaultConfig = config;
        return this;
    }

    public FabricStructureBuilder<FC, S> defaultConfig(int spacing, int separation, int salt) {
        return this.defaultConfig(new class_5314(spacing, separation, salt));
    }

    public FabricStructureBuilder<FC, S> superflatFeature(class_5312<FC, ? extends class_3195<FC>> superflatFeature) {
        Objects.requireNonNull(superflatFeature, "superflatFeature must not be null");
        this.superflatFeature = superflatFeature;
        return this;
    }

    public FabricStructureBuilder<FC, S> superflatFeature(FC config) {
        return this.superflatFeature((FC)this.structure.method_28659(config));
    }

    public FabricStructureBuilder<FC, S> adjustsSurface() {
        this.adjustsSurface = true;
        return this;
    }

    public S register() {
        Objects.requireNonNull(this.step, "Structure \"" + this.id + "\" is missing a generation step");
        Objects.requireNonNull(this.defaultConfig, "Structure \"" + this.id + "\" is missing a default config");
        class_5311.field_24822.size();
        StructureFeatureAccessor.callRegister(this.id.toString(), this.structure, this.step);
        if (!this.id.toString().equals(this.structure.method_14019())) {
            throw new IllegalStateException(String.format("Structure \"%s\" has mismatching name \"%s\". Structures should not override \"getName\".", this.id, this.structure.method_14019()));
        }
        StructuresConfigAccessor.setDefaultStructures(ImmutableMap.builder().putAll((Map)class_5311.field_24822).put(this.structure, (Object)this.defaultConfig).build());
        if (this.superflatFeature != null) {
            FlatChunkGeneratorConfigAccessor.getStructureToFeatures().put((class_3195<?>)this.structure, this.superflatFeature);
        }
        if (this.adjustsSurface) {
            StructureFeatureAccessor.setSurfaceAdjustingStructures(ImmutableList.builder().addAll((Iterable)class_3195.field_24861).add(this.structure).build());
        }
        for (class_5311 structuresConfig : FabricStructureUtil.DEFAULT_STRUCTURES_CONFIGS) {
            ((StructuresConfigHooks)structuresConfig).fabric_updateDefaultEntries();
        }
        for (class_1959 biome : class_5458.field_25933) {
            BiomeAccessor biomeAccessor = (BiomeAccessor)biome;
            Map<Integer, List<class_3195<?>>> structureLists = biomeAccessor.getStructureLists();
            if (!(structureLists instanceof HashMap)) {
                structureLists = new HashMap(structureLists);
                ((BiomeAccessor)biome).setStructureLists(structureLists);
            }
            structureLists.compute(this.step.ordinal(), (k, v) -> FabricStructureBuilder.makeMutable(v)).add(this.structure);
        }
        return this.structure;
    }

    private static List<class_3195<?>> makeMutable(List<class_3195<?>> mapValue) {
        if (mapValue == null) {
            return new ArrayList();
        }
        if (!(mapValue instanceof ArrayList)) {
            return new ArrayList(mapValue);
        }
        return mapValue;
    }
}

