/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.structure;

import java.util.List;
import net.minecraft.class_2893;
import net.minecraft.class_3195;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

@Mixin(class_3195.class)
public interface StructureFeatureAccessor {
	@Accessor("LAND_MODIFYING_STRUCTURES")
	@Mutable
	static void setSurfaceAdjustingStructures(List<class_3195<?>> surfaceAdjustingStructures) {
		throw new AssertionError("Untransformed accessor");
	}

	@Invoker
	static <F extends class_3195<?>> F callRegister(String name, F structureFeature, class_2893.class_2895 step) {
		throw new AssertionError("Untransformed accessor");
	}
}
