/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.structure;

import java.util.HashMap;
import java.util.Map;

import com.google.common.collect.ImmutableMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.mixin.structure.StructuresConfigAccessor;
import net.minecraft.class_3195;
import net.minecraft.class_5314;

public class FabricStructureImpl implements ModInitializer {
	//Keeps a map of structures to structure configs for purposes of initializing the flat chunk generator
	public static final Map<class_3195<?>, class_5314> FLAT_STRUCTURE_TO_CONFIG_MAP = new HashMap<>();

	//Keeps a map of structures to structure configs.
	public static final Map<class_3195<?>, class_5314> STRUCTURE_TO_CONFIG_MAP = new HashMap<>();

	@Override
	public void onInitialize() {
		ServerWorldEvents.LOAD.register((server, world) -> {
			// Need temp map as some mods use custom chunk generators with immutable maps in themselves.
			Map<class_3195<?>, class_5314> tempMap = new HashMap<>(world.method_14178().method_12129().method_12109().method_28598());

			tempMap.putAll(STRUCTURE_TO_CONFIG_MAP);

			//Make it immutable again
			ImmutableMap<class_3195<?>, class_5314> immutableMap = ImmutableMap.copyOf(tempMap);
			((StructuresConfigAccessor) world.method_14178().method_12129().method_12109()).setStructures(immutableMap);
		});
	}
}
