/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.structure;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.fabricmc.fabric.api.structure.v1.StructurePoolAddCallback;
import net.fabricmc.fabric.impl.structure.FabricStructurePoolImpl;
import net.minecraft.class_2378;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6900;

@Mixin(class_5455.class)
public interface DynamicRegistryManagerMixin {
	@Inject(method = "load(Lcom/mojang/serialization/DynamicOps;Lnet/minecraft/util/dynamic/RegistryLoader$LoaderAccess;Lnet/minecraft/util/registry/DynamicRegistryManager$Info;)V", at = @At("TAIL"), locals = LocalCapture.CAPTURE_FAILHARD)
	private static <E> void load(DynamicOps<JsonElement> dynamicOps, class_6900.class_6901 arg, class_5455.class_5456<E> info, CallbackInfo ci) {
		class_5321<? extends class_2378<E>> registryKey = info.comp_293();

		if (registryKey.equals(class_2378.field_25917)) {
			for (E registryEntry : arg.comp_354().method_30530(registryKey)) {
				if (registryEntry instanceof class_3785 pool) {
					StructurePoolAddCallback.EVENT.invoker().onAdd(new FabricStructurePoolImpl(pool));
				}
			}
		}
	}
}
