/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.storage;

import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.Experimental
public final class StorageUtil {
    public static <T> long move(@Nullable Storage<T> from, @Nullable Storage<T> to, Predicate<T> filter, long maxAmount, @Nullable TransactionContext transaction) {
        if (from == null || to == null) {
            return 0L;
        }
        long totalMoved = 0L;
        try (Transaction iterationTransaction = transaction == null ? Transaction.openOuter() : transaction.openNested();){
            for (StorageView<T> view : from.iterable(iterationTransaction)) {
                long maxExtracted;
                T resource;
                if (view.isResourceBlank() || !filter.test(resource = view.getResource())) continue;
                try (Transaction extractionTestTransaction = iterationTransaction.openNested();){
                    maxExtracted = view.extract(resource, maxAmount - totalMoved, extractionTestTransaction);
                    extractionTestTransaction.abort();
                }
                try (Transaction transferTransaction = iterationTransaction.openNested();){
                    long accepted = to.insert(resource, maxExtracted, transferTransaction);
                    if (view.extract(resource, accepted, transferTransaction) == accepted) {
                        totalMoved += accepted;
                        transferTransaction.commit();
                    }
                }
                if (maxAmount != totalMoved) continue;
                iterationTransaction.commit();
                long l = totalMoved;
                return l;
            }
            iterationTransaction.commit();
        }
        return totalMoved;
    }

    @Nullable
    public static <T> T findStoredResource(@Nullable Storage<T> storage, @Nullable TransactionContext transaction) {
        if (storage == null) {
            return null;
        }
        if (transaction == null) {
            try (Transaction outer = Transaction.openOuter();){
                T t = StorageUtil.findStoredResourceInner(storage, outer);
                return t;
            }
        }
        return StorageUtil.findStoredResourceInner(storage, transaction);
    }

    @Nullable
    private static <T> T findStoredResourceInner(Storage<T> storage, TransactionContext transaction) {
        for (StorageView<T> view : storage.iterable(transaction)) {
            if (view.isResourceBlank()) continue;
            return view.getResource();
        }
        return null;
    }

    @Nullable
    public static <T> T findExtractableResource(@Nullable Storage<T> storage, @Nullable TransactionContext transaction) {
        if (storage == null) {
            return null;
        }
        try (Transaction nested = transaction == null ? Transaction.openOuter() : transaction.openNested();){
            for (StorageView<T> view : storage.iterable(nested)) {
                T resource = view.getResource();
                if (view.isResourceBlank() || view.extract(resource, Long.MAX_VALUE, nested) <= 0L) continue;
                T t = resource;
                return t;
            }
        }
        return null;
    }
}

