/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.storage.base;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.Experimental
public class CombinedStorage<T, S extends Storage<T>>
implements Storage<T> {
    public final List<S> parts;

    public CombinedStorage(List<S> parts) {
        this.parts = parts;
    }

    @Override
    public boolean supportsInsertion() {
        for (Storage part : this.parts) {
            if (!part.supportsInsertion()) continue;
            return true;
        }
        return false;
    }

    @Override
    public long insert(T resource, long maxAmount, TransactionContext transaction) {
        Storage part;
        StoragePreconditions.notNegative(maxAmount);
        long amount = 0L;
        Iterator<S> iterator = this.parts.iterator();
        while (iterator.hasNext() && (amount += (part = (Storage)iterator.next()).insert(resource, maxAmount - amount, transaction)) != maxAmount) {
        }
        return amount;
    }

    @Override
    public boolean supportsExtraction() {
        for (Storage part : this.parts) {
            if (!part.supportsExtraction()) continue;
            return true;
        }
        return false;
    }

    @Override
    public long extract(T resource, long maxAmount, TransactionContext transaction) {
        Storage part;
        StoragePreconditions.notNegative(maxAmount);
        long amount = 0L;
        Iterator<S> iterator = this.parts.iterator();
        while (iterator.hasNext() && (amount += (part = (Storage)iterator.next()).extract(resource, maxAmount - amount, transaction)) != maxAmount) {
        }
        return amount;
    }

    @Override
    public Iterator<StorageView<T>> iterator(TransactionContext transaction) {
        return new CombinedIterator(transaction);
    }

    private class CombinedIterator
    implements Iterator<StorageView<T>>,
    TransactionContext.CloseCallback {
        boolean open = true;
        final TransactionContext transaction;
        final Iterator<S> partIterator;
        Iterator<StorageView<T>> currentPartIterator;

        CombinedIterator(TransactionContext transaction) {
            this.partIterator = CombinedStorage.this.parts.iterator();
            this.currentPartIterator = null;
            this.transaction = transaction;
            this.advanceCurrentPartIterator();
            transaction.addCloseCallback(this);
        }

        @Override
        public boolean hasNext() {
            return this.open && this.currentPartIterator != null && this.currentPartIterator.hasNext();
        }

        @Override
        public StorageView<T> next() {
            if (!this.open) {
                throw new NoSuchElementException("The transaction for this iterator was closed.");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StorageView returned = this.currentPartIterator.next();
            if (!this.currentPartIterator.hasNext()) {
                this.advanceCurrentPartIterator();
            }
            return returned;
        }

        private void advanceCurrentPartIterator() {
            while (this.partIterator.hasNext()) {
                this.currentPartIterator = ((Storage)this.partIterator.next()).iterator(this.transaction);
                if (!this.currentPartIterator.hasNext()) continue;
                break;
            }
        }

        @Override
        public void onClose(TransactionContext transaction, TransactionContext.Result result) {
            this.open = false;
        }
    }
}

