/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.fluid;

import com.google.common.collect.MapMaker;
import com.google.common.primitives.Ints;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.CauldronFluidContent;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class CauldronStorage
extends SnapshotParticipant<class_2680>
implements SingleSlotStorage<FluidVariant> {
    private static final Map<WorldLocation, CauldronStorage> CAULDRONS = new MapMaker().concurrencyLevel(1).weakValues().makeMap();
    private final WorldLocation location;
    private class_2680 lastReleasedSnapshot;

    public static CauldronStorage get(class_1937 world, class_2338 pos) {
        WorldLocation location = new WorldLocation(world, pos.method_10062());
        CAULDRONS.computeIfAbsent(location, CauldronStorage::new);
        return CAULDRONS.get(location);
    }

    CauldronStorage(WorldLocation location) {
        this.location = location;
    }

    @Override
    protected void releaseSnapshot(class_2680 snapshot) {
        this.lastReleasedSnapshot = snapshot;
    }

    private CauldronFluidContent getCurrentContent() {
        CauldronFluidContent content = CauldronFluidContent.getForBlock(this.createSnapshot().method_26204());
        if (content == null) {
            throw new IllegalStateException("Unexpected error: no cauldron at location " + this.location);
        }
        return content;
    }

    private void updateLevel(CauldronFluidContent newContent, int level, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        class_2680 newState = newContent.block.method_9564();
        if (newContent.levelProperty != null) {
            newState = (class_2680)newState.method_11657((class_2769)newContent.levelProperty, (Comparable)Integer.valueOf(level));
        }
        this.location.world.method_8652(this.location.pos, newState, 0);
    }

    @Override
    public long insert(FluidVariant fluidVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(fluidVariant, maxAmount);
        CauldronFluidContent insertContent = CauldronFluidContent.getForFluid(fluidVariant.getFluid());
        if (insertContent != null) {
            int maxLevelsInserted = Ints.saturatedCast((long)(maxAmount / insertContent.amountPerLevel));
            if (this.getAmount() == 0L) {
                int levelsInserted = Math.min(maxLevelsInserted, insertContent.maxLevel);
                if (levelsInserted > 0) {
                    this.updateLevel(insertContent, levelsInserted, transaction);
                }
                return (long)levelsInserted * insertContent.amountPerLevel;
            }
            CauldronFluidContent currentContent = this.getCurrentContent();
            if (fluidVariant.isOf(currentContent.fluid)) {
                int currentLevel = currentContent.currentLevel(this.createSnapshot());
                int levelsInserted = Math.min(maxLevelsInserted, currentContent.maxLevel - currentLevel);
                if (levelsInserted > 0) {
                    this.updateLevel(currentContent, currentLevel + levelsInserted, transaction);
                }
                return (long)levelsInserted * currentContent.amountPerLevel;
            }
        }
        return 0L;
    }

    @Override
    public long extract(FluidVariant fluidVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(fluidVariant, maxAmount);
        CauldronFluidContent currentContent = this.getCurrentContent();
        if (fluidVariant.isOf(currentContent.fluid)) {
            int currentLevel;
            int maxLevelsExtracted = Ints.saturatedCast((long)(maxAmount / currentContent.amountPerLevel));
            int levelsExtracted = Math.min(maxLevelsExtracted, currentLevel = currentContent.currentLevel(this.createSnapshot()));
            if (levelsExtracted > 0) {
                if (levelsExtracted == currentLevel) {
                    this.updateSnapshots(transaction);
                    this.location.world.method_8652(this.location.pos, class_2246.field_10593.method_9564(), 0);
                } else {
                    this.updateLevel(currentContent, currentLevel - levelsExtracted, transaction);
                }
            }
            return (long)levelsExtracted * currentContent.amountPerLevel;
        }
        return 0L;
    }

    @Override
    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    @Override
    public FluidVariant getResource() {
        return FluidVariant.of(this.getCurrentContent().fluid);
    }

    @Override
    public long getAmount() {
        CauldronFluidContent currentContent = this.getCurrentContent();
        return (long)currentContent.currentLevel(this.createSnapshot()) * currentContent.amountPerLevel;
    }

    @Override
    public long getCapacity() {
        CauldronFluidContent currentContent = this.getCurrentContent();
        return (long)currentContent.maxLevel * currentContent.amountPerLevel;
    }

    @Override
    public class_2680 createSnapshot() {
        return this.location.world.method_8320(this.location.pos);
    }

    @Override
    public void readSnapshot(class_2680 savedState) {
        this.location.world.method_8652(this.location.pos, savedState, 0);
    }

    @Override
    public void onFinalCommit() {
        class_2680 originalState = this.lastReleasedSnapshot;
        class_2680 state = this.createSnapshot();
        if (originalState != state) {
            this.location.world.method_8652(this.location.pos, originalState, 0);
            this.location.world.method_8501(this.location.pos, state);
        }
    }

    private record WorldLocation(class_1937 world, class_2338 pos) {
    }
}

