/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.transfer;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2325;
import net.minecraft.class_2338;
import net.minecraft.class_2345;
import net.minecraft.class_2350;
import net.minecraft.class_2601;
import net.minecraft.class_3218;

/**
 * Allows droppers to insert into ItemVariant storages.
 */
@Mixin(class_2325.class)
public class DropperBlockMixin {
	@Inject(
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/util/math/BlockPos;offset(Lnet/minecraft/util/math/Direction;)Lnet/minecraft/util/math/BlockPos;"
			),
			method = "dispense",
			locals = LocalCapture.CAPTURE_FAILHARD,
			cancellable = true,
			allow = 1
	)
	public void hookDispense(class_3218 world, class_2338 pos, CallbackInfo ci, class_2345 blockPointerImpl, class_2601 dispenser, int slot, class_1799 stack, class_2350 direction) {
		Storage<ItemVariant> target = ItemStorage.SIDED.find(world, pos.method_10093(direction), direction.method_10153());

		if (target != null) {
			Storage<ItemVariant> source = InventoryStorage.of(dispenser, null).getSlots().get(slot);

			if (StorageUtil.move(source, target, k -> true, 1, null) == 1) {
				ci.cancel();
			}
		}
	}
}
