/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;

class PlayerInventoryStorageImpl
extends InventoryStorageImpl
implements PlayerInventoryStorage {
    private final DroppedStacks droppedStacks = new DroppedStacks();
    private final class_1657 player;

    PlayerInventoryStorageImpl(class_1661 playerInventory) {
        super((class_1263)playerInventory);
        this.player = playerInventory.field_7546;
    }

    @Override
    public void offerOrDrop(ItemVariant resource, long amount, TransactionContext tx) {
        SingleSlotStorage<ItemVariant> offHandSlot;
        StoragePreconditions.notBlankNotNegative(resource, amount);
        List<SingleSlotStorage<ItemVariant>> mainSlots = this.getSlots().subList(0, 36);
        SingleSlotStorage<ItemVariant> selectedSlot = this.getSlots().get(this.player.method_31548().field_7545);
        if (((ItemVariant)selectedSlot.getResource()).equals(resource)) {
            amount -= selectedSlot.insert(resource, amount, tx);
        }
        if (((ItemVariant)(offHandSlot = this.getSlots().get(40)).getResource()).equals(resource)) {
            amount -= offHandSlot.insert(resource, amount, tx);
        }
        for (int iteration = 0; iteration < 2; ++iteration) {
            boolean allowEmptySlots = iteration == 1;
            for (SingleSlotStorage<ItemVariant> slot : mainSlots) {
                if (slot.isResourceBlank() && !allowEmptySlots) continue;
                amount -= slot.insert(resource, amount, tx);
            }
        }
        if (amount > 0L && this.player.field_6002.method_8608()) {
            this.droppedStacks.addDrop(resource, amount, tx);
        }
    }

    private class DroppedStacks
    extends SnapshotParticipant<Integer> {
        final List<ItemVariant> droppedKeys = new ArrayList<ItemVariant>();
        final List<Long> droppedCounts = new ArrayList<Long>();

        private DroppedStacks() {
        }

        void addDrop(ItemVariant key, long count, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            this.droppedKeys.add(key);
            this.droppedCounts.add(count);
        }

        @Override
        protected Integer createSnapshot() {
            return this.droppedKeys.size();
        }

        @Override
        protected void readSnapshot(Integer snapshot) {
            int previousSize = snapshot;
            while (this.droppedKeys.size() > previousSize) {
                this.droppedKeys.remove(this.droppedKeys.size() - 1);
                this.droppedCounts.remove(this.droppedCounts.size() - 1);
            }
        }

        @Override
        protected void onFinalCommit() {
            for (int i = 0; i < this.droppedKeys.size(); ++i) {
                ItemVariant key = this.droppedKeys.get(i);
                while (this.droppedCounts.get(i) > 0L) {
                    int dropped = (int)Math.min((long)key.getItem().method_7882(), this.droppedCounts.get(i));
                    PlayerInventoryStorageImpl.this.player.method_5775(key.toStack(dropped));
                    this.droppedCounts.set(i, this.droppedCounts.get(i) - (long)dropped);
                }
            }
            this.droppedKeys.clear();
            this.droppedCounts.clear();
        }
    }
}

