/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.transfer;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_2315;
import net.minecraft.class_2325;
import net.minecraft.class_2338;
import net.minecraft.class_2345;
import net.minecraft.class_2350;
import net.minecraft.class_2601;
import net.minecraft.class_3218;

/**
 * Allows droppers to insert into ItemVariant storages.
 *
 * <p>Maintainer note: it's important that we inject BEFORE the getStack() call,
 * as the returned stack can be mutated by the StorageUtil.move() call in the injected callback.
 */
@Mixin(class_2325.class)
public class DropperBlockMixin {
	@Inject(
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/block/entity/DispenserBlockEntity;getStack(I)Lnet/minecraft/item/ItemStack;"
			),
			method = "dispense",
			locals = LocalCapture.CAPTURE_FAILHARD,
			cancellable = true,
			allow = 1
	)
	public void hookDispense(class_3218 world, class_2338 pos, CallbackInfo ci, class_2345 blockPointerImpl, class_2601 dispenser, int slot) {
		if (dispenser.method_5438(slot).method_7960()) return;

		class_2350 direction = world.method_8320(pos).method_11654(class_2315.field_10918);
		Storage<ItemVariant> target = ItemStorage.SIDED.find(world, pos.method_10093(direction), direction.method_10153());

		if (target != null) {
			Storage<ItemVariant> source = InventoryStorage.of(dispenser, null).getSlots().get(slot);

			if (StorageUtil.move(source, target, k -> true, 1, null) == 1) {
				ci.cancel();
			}
		}
	}
}
