/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.transfer;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2680;

/**
 * Allows hoppers to interact with ItemVariant storages.
 */
@Mixin(class_2614.class)
public abstract class HopperBlockEntityMixin extends class_2586 implements class_1263 {
	public HopperBlockEntityMixin(class_2591<?> type) {
		super(type);
	}

	@Inject(
			at = @At("HEAD"),
			method = "insert()Z",
			cancellable = true
	)
	private void actualHookInsert(CallbackInfoReturnable<Boolean> cir) {
		hookInsert(this.field_11863, this.field_11867, this.method_11010(), this, cir);
	}

	private static void hookInsert(class_1937 world, class_2338 pos, class_2680 state, class_1263 inventory, CallbackInfoReturnable<Boolean> cir) {
		class_2350 direction = state.method_11654(class_2377.field_11129);
		class_2338 targetPos = pos.method_10093(direction);
		class_2586 targetBe = world.method_8321(targetPos);
		Storage<ItemVariant> target = ItemStorage.SIDED.find(world, targetPos, null, targetBe, direction.method_10153());

		if (target != null) {
			cir.setReturnValue(doTransfer(InventoryStorage.of(inventory, direction), target, inventory, targetBe));
		}
	}

	@Inject(
			at = @At("HEAD"),
			method = "extract(Lnet/minecraft/block/entity/Hopper;)Z",
			cancellable = true
	)
	private static void hookExtract(class_2615 hopper, CallbackInfoReturnable<Boolean> cir) {
		class_1937 world = hopper.method_10997();
		class_2338 sourcePos = new class_2338(hopper.method_11266(), hopper.method_11264() + 1.0D, hopper.method_11265());
		class_2586 sourceBe = world.method_8321(sourcePos);
		Storage<ItemVariant> source = ItemStorage.SIDED.find(world, sourcePos, null, sourceBe, class_2350.field_11033);

		if (source != null) {
			cir.setReturnValue(doTransfer(source, InventoryStorage.of(hopper, class_2350.field_11036), sourceBe, hopper));
		}
	}

	private static boolean doTransfer(Storage<ItemVariant> from, Storage<ItemVariant> to, @Nullable Object invFrom, @Nullable Object invTo) {
		if (invFrom instanceof HopperBlockEntityAccessor && invTo instanceof HopperBlockEntityAccessor) {
			HopperBlockEntityAccessor hopperFrom = (HopperBlockEntityAccessor) invFrom;
			HopperBlockEntityAccessor hopperTo = (HopperBlockEntityAccessor) invTo;
			// Hoppers have some special interactions (see HopperBlockEntity#transfer)
			boolean wasEmpty = hopperTo.method_5442();
			boolean moved = StorageUtil.move(from, to, k -> true, 1, null) == 1;

			if (moved && wasEmpty && hopperTo.fabric_getLastTickTime() >= hopperFrom.fabric_getLastTickTime()) {
				hopperTo.fabric_callSetCooldown(7);
			}

			return moved;
		} else {
			return StorageUtil.move(from, to, k -> true, 1, null) == 1;
		}
	}
}
