/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.transfer;

import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.mixin.transfer.HopperBlockEntityAccessor;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2614.class})
public abstract class HopperBlockEntityMixin
extends class_2586
implements class_1263 {
    public HopperBlockEntityMixin(class_2591<?> type) {
        super(type);
    }

    @Inject(at={@At(value="HEAD")}, method={"insert()Z"}, cancellable=true)
    private void actualHookInsert(CallbackInfoReturnable<Boolean> cir) {
        HopperBlockEntityMixin.hookInsert(this.field_11863, this.field_11867, this.method_11010(), this, cir);
    }

    private static void hookInsert(class_1937 world, class_2338 pos, class_2680 state, class_1263 inventory, CallbackInfoReturnable<Boolean> cir) {
        class_2586 targetBe;
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2377.field_11129);
        class_2338 targetPos = pos.method_10093(direction);
        Storage target = (Storage)ItemStorage.SIDED.find(world, targetPos, null, targetBe = world.method_8321(targetPos), (Object)direction.method_10153());
        if (target != null) {
            cir.setReturnValue((Object)HopperBlockEntityMixin.doTransfer(InventoryStorage.of(inventory, direction), target, inventory, targetBe));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"extract(Lnet/minecraft/block/entity/Hopper;)Z"}, cancellable=true)
    private static void hookExtract(class_2615 hopper, CallbackInfoReturnable<Boolean> cir) {
        class_2586 sourceBe;
        class_2338 sourcePos;
        class_1937 world = hopper.method_10997();
        Storage source = (Storage)ItemStorage.SIDED.find(world, sourcePos = new class_2338(hopper.method_11266(), hopper.method_11264() + 1.0, hopper.method_11265()), null, sourceBe = world.method_8321(sourcePos), (Object)class_2350.field_11033);
        if (source != null) {
            cir.setReturnValue((Object)HopperBlockEntityMixin.doTransfer(source, InventoryStorage.of((class_1263)hopper, class_2350.field_11036), sourceBe, hopper));
        }
    }

    private static boolean doTransfer(Storage<ItemVariant> from, Storage<ItemVariant> to, @Nullable Object invFrom, @Nullable Object invTo) {
        if (invFrom instanceof HopperBlockEntityAccessor && invTo instanceof HopperBlockEntityAccessor) {
            boolean moved;
            HopperBlockEntityAccessor hopperFrom = (HopperBlockEntityAccessor)invFrom;
            HopperBlockEntityAccessor hopperTo = (HopperBlockEntityAccessor)invTo;
            boolean wasEmpty = hopperTo.method_5442();
            boolean bl = moved = StorageUtil.move(from, to, k -> true, 1L, null) == 1L;
            if (moved && wasEmpty && hopperTo.fabric_getLastTickTime() >= hopperFrom.fabric_getLastTickTime()) {
                hopperTo.fabric_callSetCooldown(7);
            }
            return moved;
        }
        return StorageUtil.move(from, to, k -> true, 1L, null) == 1L;
    }
}

