/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.transfer;

import net.minecraft.class_1263;
import net.minecraft.class_2614;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

/**
 * Hopper accessors, for use in {@link HopperBlockEntityMixin}.
 */
@Mixin(class_2614.class)
public interface HopperBlockEntityAccessor extends class_1263 {
	@Invoker("setCooldown")
	void fabric_callSetCooldown(int cooldown);

	@Accessor("lastTickTime")
	long fabric_getLastTickTime();
}
