/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.transfer;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2615;

/**
 * Allows hoppers to interact with ItemVariant storages.
 */
@Mixin(class_2614.class)
public abstract class HopperBlockEntityMixin extends class_2586 implements class_1263 {
	public HopperBlockEntityMixin(class_2591<?> type) {
		super(type);
	}

	@Inject(
			at = @At(
					value = "INVOKE_ASSIGN",
					target = "Lnet/minecraft/block/entity/HopperBlockEntity;getOutputInventory()Lnet/minecraft/inventory/Inventory;"
			),
			method = "insert()Z",
			locals = LocalCapture.CAPTURE_FAILHARD,
			cancellable = true,
			allow = 1
	)
	private void hookInsert(CallbackInfoReturnable<Boolean> cir, class_1263 targetInventory) {
		// Let vanilla handle the transfer if it found an inventory.
		if (targetInventory != null) return;

		// Otherwise inject our transfer logic.
		class_2350 direction = method_11010().method_11654(class_2377.field_11129);
		class_2338 targetPos = field_11867.method_10093(direction);
		Storage<ItemVariant> target = ItemStorage.SIDED.find(field_11863, targetPos, direction.method_10153());

		if (target != null) {
			long moved = StorageUtil.move(
					InventoryStorage.of(this, direction),
					target,
					iv -> true,
					1,
					null
			);
			cir.setReturnValue(moved == 1);
		}
	}

	@Inject(
			at = @At(
					value = "INVOKE_ASSIGN",
					target = "Lnet/minecraft/block/entity/HopperBlockEntity;getInputInventory(Lnet/minecraft/block/entity/Hopper;)Lnet/minecraft/inventory/Inventory;"
			),
			method = "extract(Lnet/minecraft/block/entity/Hopper;)Z",
			locals = LocalCapture.CAPTURE_FAILHARD,
			cancellable = true,
			allow = 1
	)
	private static void hookExtract(class_2615 hopper, CallbackInfoReturnable<Boolean> cir, class_1263 inputInventory) {
		// Let vanilla handle the transfer if it found an inventory.
		if (inputInventory != null) return;

		// Otherwise inject our transfer logic.
		class_2338 sourcePos = new class_2338(hopper.method_11266(), hopper.method_11264() + 1.0D, hopper.method_11265());
		Storage<ItemVariant> source = ItemStorage.SIDED.find(hopper.method_10997(), sourcePos, class_2350.field_11033);

		if (source != null) {
			long moved = StorageUtil.move(
					source,
					InventoryStorage.of(hopper, class_2350.field_11036),
					iv -> true,
					1,
					null
			);
			cir.setReturnValue(moved == 1);
		}
	}
}
