/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.fluid.base;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.Experimental
@ApiStatus.ScheduledForRemoval
public abstract class SingleFluidStorage
extends SnapshotParticipant<ResourceAmount<FluidVariant>>
implements SingleSlotStorage<FluidVariant> {
    public FluidVariant fluidVariant = FluidVariant.blank();
    public long amount;

    protected void markDirty() {
    }

    protected boolean canInsert(FluidVariant fluidVariant) {
        return true;
    }

    protected boolean canExtract(FluidVariant fluidVariant) {
        return true;
    }

    protected abstract long getCapacity(FluidVariant var1);

    @Override
    public final boolean isResourceBlank() {
        return this.fluidVariant.isBlank();
    }

    @Override
    public final FluidVariant getResource() {
        return this.fluidVariant;
    }

    @Override
    public final long getAmount() {
        return this.fluidVariant.isBlank() ? 0L : this.amount;
    }

    @Override
    public final long getCapacity() {
        return this.getCapacity(this.fluidVariant);
    }

    @Override
    public final long insert(FluidVariant insertedFluid, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(insertedFluid, maxAmount);
        if ((insertedFluid.equals(this.fluidVariant) || this.fluidVariant.isBlank()) && this.canInsert(insertedFluid)) {
            long insertedAmount = Math.min(maxAmount, this.getCapacity(insertedFluid) - this.amount);
            if (insertedAmount > 0L) {
                this.updateSnapshots(transaction);
                if (this.fluidVariant.isBlank()) {
                    this.amount = 0L;
                }
                this.amount += insertedAmount;
                this.fluidVariant = insertedFluid;
            }
            return insertedAmount;
        }
        return 0L;
    }

    @Override
    public final long extract(FluidVariant extractedFluid, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(extractedFluid, maxAmount);
        if (extractedFluid.equals(this.fluidVariant) && this.canExtract(extractedFluid)) {
            long extractedAmount = Math.min(maxAmount, this.amount);
            if (extractedAmount > 0L) {
                this.updateSnapshots(transaction);
                this.amount -= extractedAmount;
                if (this.amount == 0L) {
                    this.fluidVariant = FluidVariant.blank();
                }
            }
            return extractedAmount;
        }
        return 0L;
    }

    @Override
    protected final ResourceAmount<FluidVariant> createSnapshot() {
        return new ResourceAmount<FluidVariant>(this.fluidVariant, this.amount);
    }

    @Override
    protected final void readSnapshot(ResourceAmount<FluidVariant> snapshot) {
        this.fluidVariant = snapshot.resource();
        this.amount = snapshot.amount();
    }

    @Override
    protected final void onFinalCommit() {
        this.markDirty();
    }
}

