/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.transaction;

import java.util.ArrayList;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class TransactionManagerImpl {
    public static final ThreadLocal<TransactionManagerImpl> MANAGERS = ThreadLocal.withInitial(TransactionManagerImpl::new);
    private final Thread thread = Thread.currentThread();
    private final ArrayList<TransactionImpl> stack = new ArrayList();
    private final ArrayList<TransactionContext.OuterCloseCallback> outerCloseCallbacks = new ArrayList();
    private int currentDepth = -1;

    public boolean isOpen() {
        return this.currentDepth > -1;
    }

    public Transaction openOuter() {
        if (this.isOpen()) {
            throw new IllegalStateException("An outer transaction is already active on this thread.");
        }
        return this.open();
    }

    @Nullable
    public TransactionContext getCurrentUnsafe() {
        if (this.currentDepth == -1) {
            return null;
        }
        if (this.stack.get((int)this.currentDepth).isOpen) {
            return this.stack.get(this.currentDepth);
        }
        throw new IllegalStateException("May not call getCurrentUnsafe() from a close callback.");
    }

    Transaction open() {
        ++this.currentDepth;
        if (this.stack.size() == this.currentDepth) {
            this.stack.add(new TransactionImpl(this.currentDepth));
        }
        TransactionImpl current = this.stack.get(this.currentDepth);
        current.isOpen = true;
        return current;
    }

    void validateCurrentThread() {
        if (Thread.currentThread() != this.thread) {
            String errorMessage = String.format("Attempted to access transaction state from thread %s, but this transaction is only valid on thread %s.", Thread.currentThread().getName(), this.thread.getName());
            throw new IllegalStateException(errorMessage);
        }
    }

    private class TransactionImpl
    implements Transaction {
        final int nestingDepth;
        final ArrayList<TransactionContext.CloseCallback> closeCallbacks = new ArrayList();
        boolean isOpen = false;

        TransactionImpl(int nestingDepth) {
            this.nestingDepth = nestingDepth;
        }

        void validateCurrentTransaction() {
            TransactionManagerImpl.this.validateCurrentThread();
            if (TransactionManagerImpl.this.currentDepth == -1 || TransactionManagerImpl.this.stack.get(TransactionManagerImpl.this.currentDepth) != this) {
                String errorMessage = String.format("Transaction function was called on a transaction with depth %d, but the current transaction has depth %d.", this.nestingDepth, TransactionManagerImpl.this.currentDepth);
                throw new IllegalStateException(errorMessage);
            }
        }

        private void validateOpen() {
            if (!this.isOpen) {
                throw new IllegalStateException("Transaction operation cannot be applied to a closed transaction.");
            }
        }

        @Override
        public Transaction openNested() {
            this.validateCurrentTransaction();
            this.validateOpen();
            return TransactionManagerImpl.this.open();
        }

        private void close(TransactionContext.Result result) {
            int i;
            this.validateCurrentTransaction();
            this.validateOpen();
            this.isOpen = false;
            Throwable closeException = null;
            for (i = this.closeCallbacks.size() - 1; i >= 0; --i) {
                try {
                    this.closeCallbacks.get(i).onClose(this, result);
                    continue;
                }
                catch (Exception exception) {
                    if (closeException == null) {
                        closeException = new RuntimeException("Encountered an exception while invoking a transaction close callback.", exception);
                        continue;
                    }
                    closeException.addSuppressed(exception);
                }
            }
            this.closeCallbacks.clear();
            if (TransactionManagerImpl.this.currentDepth == 0) {
                for (i = TransactionManagerImpl.this.outerCloseCallbacks.size() - 1; i >= 0; --i) {
                    try {
                        TransactionManagerImpl.this.outerCloseCallbacks.get(i).afterOuterClose(result);
                        continue;
                    }
                    catch (Exception exception) {
                        if (closeException == null) {
                            closeException = new RuntimeException("Encountered an exception while invoking a transaction outer close callback.", exception);
                            continue;
                        }
                        closeException.addSuppressed(exception);
                    }
                }
                TransactionManagerImpl.this.outerCloseCallbacks.clear();
            }
            --TransactionManagerImpl.this.currentDepth;
            if (closeException != null) {
                throw closeException;
            }
        }

        @Override
        public void abort() {
            this.close(TransactionContext.Result.ABORTED);
        }

        @Override
        public void commit() {
            this.close(TransactionContext.Result.COMMITTED);
        }

        @Override
        public void close() {
            if (TransactionManagerImpl.this.isOpen() && this.isOpen) {
                this.abort();
            }
        }

        @Override
        public int nestingDepth() {
            TransactionManagerImpl.this.validateCurrentThread();
            return this.nestingDepth;
        }

        @Override
        public Transaction getOpenTransaction(int nestingDepth) {
            TransactionManagerImpl.this.validateCurrentThread();
            if (nestingDepth < 0) {
                throw new IndexOutOfBoundsException("Nesting depth may not be negative.");
            }
            if (nestingDepth > TransactionManagerImpl.this.currentDepth) {
                throw new IndexOutOfBoundsException("There is no open transaction for nesting depth " + nestingDepth);
            }
            TransactionImpl transaction = TransactionManagerImpl.this.stack.get(nestingDepth);
            transaction.validateOpen();
            return transaction;
        }

        @Override
        public void addCloseCallback(TransactionContext.CloseCallback closeCallback) {
            TransactionManagerImpl.this.validateCurrentThread();
            this.validateOpen();
            this.closeCallbacks.add(closeCallback);
        }

        @Override
        public void addOuterCloseCallback(TransactionContext.OuterCloseCallback outerCloseCallback) {
            TransactionManagerImpl.this.validateCurrentThread();
            if (TransactionManagerImpl.this.currentDepth == -1) {
                throw new IllegalStateException("There is no open transaction on this thread.");
            }
            TransactionManagerImpl.this.outerCloseCallbacks.add(outerCloseCallback);
        }
    }
}

