/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantCache;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ItemVariantImpl
implements ItemVariant {
    private static final Logger LOGGER = LogManager.getLogger((String)"fabric-transfer-api-v1/item");
    private final class_1792 item;
    @Nullable
    private final class_2487 nbt;
    private final int hashCode;

    public static ItemVariant of(class_1792 item, @Nullable class_2487 tag) {
        Objects.requireNonNull(item, "Item may not be null.");
        if (tag == null || item == class_1802.field_8162) {
            return ((ItemVariantCache)item).fabric_getCachedItemVariant();
        }
        return new ItemVariantImpl(item, tag);
    }

    public ItemVariantImpl(class_1792 item, class_2487 nbt) {
        this.item = item;
        this.nbt = nbt == null ? null : nbt.method_10553();
        this.hashCode = Objects.hash(item, nbt);
    }

    @Override
    public class_1792 getObject() {
        return this.item;
    }

    @Override
    @Nullable
    public class_2487 getNbt() {
        return this.nbt;
    }

    @Override
    public boolean isBlank() {
        return this.item == class_1802.field_8162;
    }

    @Override
    public class_2487 toNbt() {
        class_2487 result = new class_2487();
        result.method_10582("item", class_2378.field_11142.method_10221((Object)this.item).toString());
        if (this.nbt != null) {
            result.method_10566("tag", (class_2520)this.nbt.method_10553());
        }
        return result;
    }

    public static ItemVariant fromNbt(class_2487 tag) {
        try {
            class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(tag.method_10558("item")));
            class_2487 aTag = tag.method_10545("tag") ? tag.method_10562("tag") : null;
            return ItemVariantImpl.of(item, aTag);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.debug("Tried to load an invalid ItemVariant from NBT: {}", (Object)tag, (Object)runtimeException);
            return ItemVariant.blank();
        }
    }

    @Override
    public void toPacket(class_2540 buf) {
        if (this.isBlank()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.method_10804(class_1792.method_7880((class_1792)this.item));
            buf.method_10794(this.nbt);
        }
    }

    public static ItemVariant fromPacket(class_2540 buf) {
        if (!buf.readBoolean()) {
            return ItemVariant.blank();
        }
        class_1792 item = class_1792.method_7875((int)buf.method_10816());
        class_2487 nbt = buf.method_10798();
        return ItemVariantImpl.of(item, nbt);
    }

    public String toString() {
        return "ItemVariantImpl{item=" + this.item + ", tag=" + this.nbt + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemVariantImpl ItemVariant2 = (ItemVariantImpl)o;
        return this.hashCode == ItemVariant2.hashCode && this.item == ItemVariant2.item && this.nbtMatches(ItemVariant2.nbt);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

