/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.context;

import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.context.InitialContentsContainerItemContext;
import net.fabricmc.fabric.impl.transfer.context.PlayerContainerItemContext;
import net.fabricmc.fabric.impl.transfer.context.SingleSlotContainerItemContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ContainerItemContext {
    public static ContainerItemContext ofPlayerHand(class_1657 player, class_1268 hand) {
        return new PlayerContainerItemContext(player, hand);
    }

    public static ContainerItemContext ofPlayerCursor(class_1657 player) {
        return ContainerItemContext.ofPlayerSlot(player, PlayerInventoryStorage.getCursorStorage(player));
    }

    public static ContainerItemContext ofPlayerSlot(class_1657 player, SingleSlotStorage<ItemVariant> slot) {
        return new PlayerContainerItemContext(player, slot);
    }

    public static ContainerItemContext ofSingleSlot(SingleSlotStorage<ItemVariant> slot) {
        return new SingleSlotContainerItemContext(slot);
    }

    public static ContainerItemContext withInitial(class_1799 initialContent) {
        return ContainerItemContext.withInitial(ItemVariant.of(initialContent), initialContent.method_7947());
    }

    public static ContainerItemContext withInitial(ItemVariant initialVariant, long initialAmount) {
        StoragePreconditions.notBlankNotNegative(initialVariant, initialAmount);
        return new InitialContentsContainerItemContext(initialVariant, initialAmount);
    }

    @Nullable
    default public <A> A find(ItemApiLookup<A, ContainerItemContext> lookup) {
        return (A)(this.getItemVariant().isBlank() ? null : lookup.find(this.getItemVariant().toStack(), (Object)this));
    }

    default public ItemVariant getItemVariant() {
        return (ItemVariant)this.getMainSlot().getResource();
    }

    default public long getAmount() {
        if (this.getItemVariant().isBlank()) {
            throw new IllegalStateException("Amount may not be queried when the current item variant is blank.");
        }
        return this.getMainSlot().getAmount();
    }

    default public long insert(ItemVariant itemVariant, long maxAmount, TransactionContext transaction) {
        long mainInserted = this.getMainSlot().insert(itemVariant, maxAmount, transaction);
        long overflowInserted = this.insertOverflow(itemVariant, maxAmount - mainInserted, transaction);
        return mainInserted + overflowInserted;
    }

    default public long extract(ItemVariant itemVariant, long maxAmount, TransactionContext transaction) {
        return this.getMainSlot().extract(itemVariant, maxAmount, transaction);
    }

    default public long exchange(ItemVariant newVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(newVariant, maxAmount);
        try (Transaction nested = transaction.openNested();){
            long extracted = this.extract(this.getItemVariant(), maxAmount, nested);
            if (this.insert(newVariant, extracted, nested) == extracted) {
                nested.commit();
                long l = extracted;
                return l;
            }
        }
        return 0L;
    }

    public SingleSlotStorage<ItemVariant> getMainSlot();

    public long insertOverflow(ItemVariant var1, long var2, TransactionContext var4);

    public List<SingleSlotStorage<ItemVariant>> getAdditionalSlots();
}

