/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.storage;

import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class StorageUtil {
    public static <T> long move(@Nullable Storage<T> from, @Nullable Storage<T> to, Predicate<T> filter, long maxAmount, @Nullable TransactionContext transaction) {
        if (from == null || to == null) {
            return 0L;
        }
        long totalMoved = 0L;
        try (Transaction iterationTransaction = Transaction.openNested(transaction);){
            for (StorageView<T> view : from.iterable(iterationTransaction)) {
                long maxExtracted;
                T resource;
                if (view.isResourceBlank() || !filter.test(resource = view.getResource())) continue;
                try (Transaction extractionTestTransaction = iterationTransaction.openNested();){
                    maxExtracted = view.extract(resource, maxAmount - totalMoved, extractionTestTransaction);
                    extractionTestTransaction.abort();
                }
                try (Transaction transferTransaction = iterationTransaction.openNested();){
                    long accepted = to.insert(resource, maxExtracted, transferTransaction);
                    if (view.extract(resource, accepted, transferTransaction) == accepted) {
                        totalMoved += accepted;
                        transferTransaction.commit();
                    }
                }
                if (maxAmount != totalMoved) continue;
                iterationTransaction.commit();
                long l = totalMoved;
                return l;
            }
            iterationTransaction.commit();
        }
        return totalMoved;
    }

    @Nullable
    public static <T> T findStoredResource(@Nullable Storage<T> storage, @Nullable TransactionContext transaction) {
        return (T)StorageUtil.findStoredResource(storage, r -> true, transaction);
    }

    @Nullable
    public static <T> T findStoredResource(@Nullable Storage<T> storage, Predicate<T> filter, @Nullable TransactionContext transaction) {
        if (storage == null) {
            return null;
        }
        if (transaction == null) {
            try (Transaction outer = Transaction.openOuter();){
                T t = StorageUtil.findStoredResourceInner(storage, filter, outer);
                return t;
            }
        }
        return StorageUtil.findStoredResourceInner(storage, filter, transaction);
    }

    @Nullable
    private static <T> T findStoredResourceInner(Storage<T> storage, Predicate<T> filter, TransactionContext transaction) {
        for (StorageView<T> view : storage.iterable(transaction)) {
            if (view.isResourceBlank() || !filter.test(view.getResource())) continue;
            return view.getResource();
        }
        return null;
    }

    @Nullable
    public static <T> T findExtractableResource(@Nullable Storage<T> storage, @Nullable TransactionContext transaction) {
        return (T)StorageUtil.findExtractableResource(storage, r -> true, transaction);
    }

    @Nullable
    public static <T> T findExtractableResource(@Nullable Storage<T> storage, Predicate<T> filter, @Nullable TransactionContext transaction) {
        if (storage == null) {
            return null;
        }
        try (Transaction nested = Transaction.openNested(transaction);){
            for (StorageView<T> view : storage.iterable(nested)) {
                T resource = view.getResource();
                if (view.isResourceBlank() || !filter.test(resource) || view.extract(resource, Long.MAX_VALUE, nested) <= 0L) continue;
                T t = resource;
                return t;
            }
        }
        return null;
    }

    @Nullable
    public static <T> ResourceAmount<T> findExtractableContent(@Nullable Storage<T> storage, @Nullable TransactionContext transaction) {
        return StorageUtil.findExtractableContent(storage, r -> true, transaction);
    }

    @Nullable
    public static <T> ResourceAmount<T> findExtractableContent(@Nullable Storage<T> storage, Predicate<T> filter, @Nullable TransactionContext transaction) {
        long extractableAmount;
        T extractableResource = StorageUtil.findExtractableResource(storage, filter, transaction);
        if (extractableResource != null && (extractableAmount = storage.simulateExtract(extractableResource, Long.MAX_VALUE, transaction)) > 0L) {
            return new ResourceAmount<T>(extractableResource, extractableAmount);
        }
        return null;
    }

    public static <T> int calculateComparatorOutput(@Nullable Storage<T> storage, @Nullable TransactionContext transaction) {
        if (storage == null) {
            return 0;
        }
        if (transaction == null) {
            try (Transaction outer = Transaction.openOuter();){
                int n = StorageUtil.calculateComparatorOutputInner(storage, outer);
                return n;
            }
        }
        return StorageUtil.calculateComparatorOutputInner(storage, transaction);
    }

    private static <T> int calculateComparatorOutputInner(Storage<T> storage, TransactionContext transaction) {
        double fillPercentage = 0.0;
        int viewCount = 0;
        boolean hasNonEmptyView = false;
        for (StorageView<T> view : storage.iterable(transaction)) {
            ++viewCount;
            if (view.getAmount() <= 0L) continue;
            fillPercentage += (double)view.getAmount() / (double)view.getCapacity();
            hasNonEmptyView = true;
        }
        return class_3532.method_15357((double)(fillPercentage / (double)viewCount * 14.0)) + (hasNonEmptyView ? 1 : 0);
    }
}

