/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.fluid;

import com.google.common.collect.MapMaker;
import com.google.common.primitives.Ints;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class CauldronStorage
extends SnapshotParticipant<class_2680>
implements SingleSlotStorage<FluidVariant> {
    private static final Map<WorldLocation, CauldronStorage> CAULDRONS = new MapMaker().concurrencyLevel(1).weakValues().makeMap();
    private final WorldLocation location;
    private class_2680 lastReleasedSnapshot;

    public static CauldronStorage get(class_1937 world, class_2338 pos) {
        WorldLocation location = new WorldLocation(world, pos.method_10062());
        return CAULDRONS.computeIfAbsent(location, CauldronStorage::new);
    }

    CauldronStorage(WorldLocation location) {
        this.location = location;
    }

    @Override
    protected void releaseSnapshot(class_2680 snapshot) {
        this.lastReleasedSnapshot = snapshot;
    }

    private int getLevel() {
        class_2680 state = this.createSnapshot();
        if (!state.method_27852(class_2246.field_10593)) {
            throw new IllegalStateException("Unexpected error: no cauldron at location " + this.location);
        }
        return (Integer)state.method_11654((class_2769)class_2275.field_10745);
    }

    private void updateLevel(int level, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        class_2680 newState = (class_2680)class_2246.field_10593.method_9564().method_11657((class_2769)class_2275.field_10745, (Comparable)Integer.valueOf(level));
        this.location.world.method_8652(this.location.pos, newState, 0);
    }

    @Override
    public long insert(FluidVariant fluidVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(fluidVariant, maxAmount);
        if (fluidVariant.isOf(class_3612.field_15910)) {
            int currentLevel;
            int maxLevelsInserted = Ints.saturatedCast((long)(maxAmount / 27000L));
            int levelsInserted = Math.min(maxLevelsInserted, 3 - (currentLevel = this.getLevel()));
            if (levelsInserted > 0) {
                this.updateLevel(currentLevel + levelsInserted, transaction);
            }
            return (long)levelsInserted * 27000L;
        }
        return 0L;
    }

    @Override
    public long extract(FluidVariant fluidVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(fluidVariant, maxAmount);
        if (fluidVariant.isOf(class_3612.field_15910)) {
            int currentLevel;
            int maxLevelsExtracted = Ints.saturatedCast((long)(maxAmount / 27000L));
            int levelsExtracted = Math.min(maxLevelsExtracted, currentLevel = this.getLevel());
            if (levelsExtracted > 0) {
                this.updateLevel(currentLevel - levelsExtracted, transaction);
            }
            return (long)levelsExtracted * 27000L;
        }
        return 0L;
    }

    @Override
    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    @Override
    public FluidVariant getResource() {
        return FluidVariant.of((class_3611)class_3612.field_15910);
    }

    @Override
    public long getAmount() {
        return (long)this.getLevel() * 27000L;
    }

    @Override
    public long getCapacity() {
        return 81000L;
    }

    @Override
    public class_2680 createSnapshot() {
        return this.location.world.method_8320(this.location.pos);
    }

    @Override
    public void readSnapshot(class_2680 savedState) {
        this.location.world.method_8652(this.location.pos, savedState, 0);
    }

    @Override
    public void onFinalCommit() {
        class_2680 originalState = this.lastReleasedSnapshot;
        class_2680 state = this.createSnapshot();
        if (originalState != state) {
            this.location.world.method_8652(this.location.pos, originalState, 0);
            this.location.world.method_8501(this.location.pos, state);
        }
    }

    private static final class WorldLocation {
        private final class_1937 world;
        private final class_2338 pos;

        WorldLocation(class_1937 world, class_2338 pos) {
            this.world = world;
            this.pos = pos;
        }

        public class_1937 world() {
            return this.world;
        }

        public class_2338 pos() {
            return this.pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorldLocation that = (WorldLocation)o;
            return Objects.equals(this.world, that.world) && Objects.equals(this.pos, that.pos);
        }

        public int hashCode() {
            return Objects.hash(this.world, this.pos);
        }
    }
}

