/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1661;

class PlayerInventoryStorageImpl
extends InventoryStorageImpl
implements PlayerInventoryStorage {
    private final DroppedStacks droppedStacks = new DroppedStacks();
    private final class_1661 playerInventory;

    PlayerInventoryStorageImpl(class_1661 playerInventory) {
        super((class_1263)playerInventory);
        this.playerInventory = playerInventory;
    }

    @Override
    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return this.offer(resource, maxAmount, transaction);
    }

    @Override
    public long offer(ItemVariant resource, long amount, TransactionContext tx) {
        StoragePreconditions.notBlankNotNegative(resource, amount);
        long initialAmount = amount;
        List mainSlots = this.getSlots().subList(0, 36);
        for (class_1268 hand : class_1268.values()) {
            SingleSlotStorage<ItemVariant> handSlot = this.getHandSlot(hand);
            if (!((ItemVariant)handSlot.getResource()).equals(resource) || (amount -= handSlot.insert(resource, amount, tx)) != 0L) continue;
            return initialAmount;
        }
        amount -= StorageUtil.insertStacking(mainSlots, resource, amount, tx);
        return initialAmount - amount;
    }

    @Override
    public void drop(ItemVariant resource, long amount, TransactionContext tx) {
        StoragePreconditions.notBlankNotNegative(resource, amount);
        if (amount > 0L && !this.playerInventory.field_7546.field_6002.method_8608()) {
            this.droppedStacks.addDrop(resource, amount, tx);
        }
    }

    @Override
    public SingleSlotStorage<ItemVariant> getHandSlot(class_1268 hand) {
        if (Objects.requireNonNull(hand) == class_1268.field_5808) {
            if (class_1661.method_7380((int)this.playerInventory.field_7545)) {
                return this.getSlot(this.playerInventory.field_7545);
            }
            throw new RuntimeException("Unexpected player selected slot: " + this.playerInventory.field_7545);
        }
        if (hand == class_1268.field_5810) {
            return this.getSlot(40);
        }
        throw new UnsupportedOperationException("Unknown hand: " + hand);
    }

    private class DroppedStacks
    extends SnapshotParticipant<Integer> {
        final List<ItemVariant> droppedKeys = new ArrayList<ItemVariant>();
        final List<Long> droppedCounts = new ArrayList<Long>();

        private DroppedStacks() {
        }

        void addDrop(ItemVariant key, long count, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            this.droppedKeys.add(key);
            this.droppedCounts.add(count);
        }

        @Override
        protected Integer createSnapshot() {
            return this.droppedKeys.size();
        }

        @Override
        protected void readSnapshot(Integer snapshot) {
            int previousSize = snapshot;
            while (this.droppedKeys.size() > previousSize) {
                this.droppedKeys.remove(this.droppedKeys.size() - 1);
                this.droppedCounts.remove(this.droppedCounts.size() - 1);
            }
        }

        @Override
        protected void onFinalCommit() {
            for (int i = 0; i < this.droppedKeys.size(); ++i) {
                ItemVariant key = this.droppedKeys.get(i);
                while (this.droppedCounts.get(i) > 0L) {
                    int dropped = (int)Math.min((long)key.getItem().method_7882(), this.droppedCounts.get(i));
                    ((PlayerInventoryStorageImpl)PlayerInventoryStorageImpl.this).playerInventory.field_7546.method_5775(key.toStack(dropped));
                    this.droppedCounts.set(i, this.droppedCounts.get(i) - (long)dropped);
                }
            }
            this.droppedKeys.clear();
            this.droppedCounts.clear();
        }
    }
}

