/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantImpl;
import net.fabricmc.fabric.impl.transfer.item.SpecialLogicInventory;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2589;
import net.minecraft.class_2609;
import net.minecraft.class_2627;

class InventorySlotWrapper
extends SingleStackStorage {
    private final InventoryStorageImpl storage;
    final int slot;
    private final SpecialLogicInventory specialInv;
    private class_1799 lastReleasedSnapshot = null;

    InventorySlotWrapper(InventoryStorageImpl storage, int slot) {
        SpecialLogicInventory specialInv;
        this.storage = storage;
        this.slot = slot;
        class_1263 class_12632 = storage.inventory;
        this.specialInv = class_12632 instanceof SpecialLogicInventory ? (specialInv = (SpecialLogicInventory)class_12632) : null;
    }

    @Override
    protected class_1799 getStack() {
        return this.storage.inventory.method_5438(this.slot);
    }

    @Override
    protected void setStack(class_1799 stack) {
        if (this.specialInv == null) {
            this.storage.inventory.method_5447(this.slot, stack);
        } else {
            this.specialInv.fabric_setSuppress(true);
            try {
                this.storage.inventory.method_5447(this.slot, stack);
            }
            finally {
                this.specialInv.fabric_setSuppress(false);
            }
        }
    }

    @Override
    public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        if (!this.canInsert(this.slot, ((ItemVariantImpl)insertedVariant).getCachedStack())) {
            return 0L;
        }
        long ret = super.insert(insertedVariant, maxAmount, transaction);
        if (this.specialInv != null && ret > 0L) {
            this.specialInv.fabric_onTransfer(this.slot, transaction);
        }
        return ret;
    }

    private boolean canInsert(int slot, class_1799 stack) {
        class_1263 class_12632 = this.storage.inventory;
        if (class_12632 instanceof class_2627) {
            class_2627 shulker = (class_2627)class_12632;
            return shulker.method_5492(slot, stack, null);
        }
        return this.storage.inventory.method_5437(slot, stack);
    }

    @Override
    public long extract(ItemVariant variant, long maxAmount, TransactionContext transaction) {
        long ret = super.extract(variant, maxAmount, transaction);
        if (this.specialInv != null && ret > 0L) {
            this.specialInv.fabric_onTransfer(this.slot, transaction);
        }
        return ret;
    }

    @Override
    public int getCapacity(ItemVariant variant) {
        if (this.storage.inventory instanceof class_2609 && this.slot == 1 && variant.isOf(class_1802.field_8550)) {
            return 1;
        }
        if (this.storage.inventory instanceof class_2589 && this.slot < 3) {
            return 1;
        }
        return Math.min(this.storage.inventory.method_5444(), variant.getItem().method_7882());
    }

    @Override
    public void updateSnapshots(TransactionContext transaction) {
        this.storage.markDirtyParticipant.updateSnapshots(transaction);
        super.updateSnapshots(transaction);
    }

    @Override
    protected void releaseSnapshot(class_1799 snapshot) {
        this.lastReleasedSnapshot = snapshot;
    }

    @Override
    protected void onFinalCommit() {
        class_1799 original = this.lastReleasedSnapshot;
        class_1799 currentStack = this.getStack();
        class_1263 class_12632 = this.storage.inventory;
        if (class_12632 instanceof SpecialLogicInventory) {
            SpecialLogicInventory specialLogicInv = (SpecialLogicInventory)class_12632;
            specialLogicInv.fabric_onFinalCommit(this.slot, original, currentStack);
        }
        if (!original.method_7960() && original.method_7909() == currentStack.method_7909()) {
            original.method_7939(currentStack.method_7947());
            original.method_7980(currentStack.method_7985() ? currentStack.method_7969().method_10553() : null);
            this.setStack(original);
        } else {
            original.method_7939(0);
        }
    }
}

