/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.fluid;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantCache;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidVariantImpl
implements FluidVariant {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-transfer-api-v1/fluid");
    private final class_3611 fluid;
    @Nullable
    private final class_2487 nbt;
    private final int hashCode;

    public static FluidVariant of(class_3611 fluid, @Nullable class_2487 nbt) {
        Objects.requireNonNull(fluid, "Fluid may not be null.");
        if (!fluid.method_15793(fluid.method_15785()) && fluid != class_3612.field_15906) {
            if (fluid instanceof class_3609) {
                class_3609 flowable = (class_3609)fluid;
                fluid = flowable.method_15751();
            } else {
                class_2960 id = class_2378.field_11154.method_10221((Object)fluid);
                throw new IllegalArgumentException("Cannot convert flowing fluid %s (%s) into a still fluid.".formatted(id, fluid));
            }
        }
        if (nbt == null || fluid == class_3612.field_15906) {
            return ((FluidVariantCache)fluid).fabric_getCachedFluidVariant();
        }
        return new FluidVariantImpl(fluid, nbt);
    }

    public FluidVariantImpl(class_3611 fluid, class_2487 nbt) {
        this.fluid = fluid;
        this.nbt = nbt == null ? null : nbt.method_10553();
        this.hashCode = Objects.hash(fluid, nbt);
    }

    @Override
    public boolean isBlank() {
        return this.fluid == class_3612.field_15906;
    }

    @Override
    public class_3611 getObject() {
        return this.fluid;
    }

    @Override
    @Nullable
    public class_2487 getNbt() {
        return this.nbt;
    }

    @Override
    public class_2487 toNbt() {
        class_2487 result = new class_2487();
        result.method_10582("fluid", class_2378.field_11154.method_10221((Object)this.fluid).toString());
        if (this.nbt != null) {
            result.method_10566("tag", (class_2520)this.nbt.method_10553());
        }
        return result;
    }

    public static FluidVariant fromNbt(class_2487 compound) {
        try {
            class_3611 fluid = (class_3611)class_2378.field_11154.method_10223(new class_2960(compound.method_10558("fluid")));
            class_2487 nbt = compound.method_10545("tag") ? compound.method_10562("tag") : null;
            return FluidVariantImpl.of(fluid, nbt);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.debug("Tried to load an invalid FluidVariant from NBT: {}", (Object)compound, (Object)runtimeException);
            return FluidVariant.blank();
        }
    }

    @Override
    public void toPacket(class_2540 buf) {
        if (this.isBlank()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.method_10804(class_2378.field_11154.method_10206((Object)this.fluid));
            buf.method_10794(this.nbt);
        }
    }

    public static FluidVariant fromPacket(class_2540 buf) {
        if (!buf.readBoolean()) {
            return FluidVariant.blank();
        }
        class_3611 fluid = (class_3611)class_2378.field_11154.method_10200(buf.method_10816());
        class_2487 nbt = buf.method_10798();
        return FluidVariantImpl.of(fluid, nbt);
    }

    public String toString() {
        return "FluidVariantImpl{fluid=" + this.fluid + ", tag=" + this.nbt + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidVariantImpl fluidVariant = (FluidVariantImpl)o;
        return this.hashCode == fluidVariant.hashCode && this.fluid == fluidVariant.fluid && this.nbtMatches(fluidVariant.nbt);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

