/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.transfer;

import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public final class DebugMessages {
	public static String forGlobalPos(@Nullable class_1937 world, class_2338 pos) {
		String dimension = world != null ? world.method_44013().method_29177().toString() : "<no dimension>";
		return dimension + "@" + pos.method_23854();
	}

	public static String forPlayer(class_1657 player) {
		return player.method_5476() + "/" + player.method_5845();
	}

	public static String forInventory(@Nullable class_1263 inventory) {
		if (inventory == null) {
			return "~~NULL~~"; // like in crash reports
		} else if (inventory instanceof class_1661 playerInventory) {
			return forPlayer(playerInventory.field_7546);
		} else {
			String result = inventory.toString();

			if (inventory instanceof class_2586 blockEntity) {
				result += " (%s, %s)".formatted(blockEntity.method_11010(), forGlobalPos(blockEntity.method_10997(), blockEntity.method_11016()));
			}

			return result;
		}
	}
}
