/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.transfer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantImpl;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantImpl;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;

public class VariantCodecs {
	public static final Codec<ItemVariant> ITEM_CODEC = RecordCodecBuilder.create(instance -> instance.group(
			class_7923.field_41178.method_40294().fieldOf("item").forGetter(ItemVariant::getRegistryEntry),
			class_9326.field_49589.optionalFieldOf("components", class_9326.field_49588).forGetter(ItemVariant::getComponents)
		).apply(instance, ItemVariantImpl::of)
	);
	public static final class_9139<class_9129, ItemVariant> ITEM_PACKET_CODEC = class_9139.method_56435(
			class_9135.method_56383(class_7924.field_41197), ItemVariant::getRegistryEntry,
			class_9326.field_49590, ItemVariant::getComponents,
			ItemVariantImpl::of
	);

	public static final Codec<FluidVariant> FLUID_CODEC = RecordCodecBuilder.create(instance -> instance.group(
			class_7923.field_41173.method_40294().fieldOf("fluid").forGetter(FluidVariant::getRegistryEntry),
			class_9326.field_49589.optionalFieldOf("components", class_9326.field_49588).forGetter(FluidVariant::getComponents)
		).apply(instance, FluidVariantImpl::of)
	);
	public static final class_9139<class_9129, FluidVariant> FLUID_PACKET_CODEC = class_9139.method_56435(
			class_9135.method_56383(class_7924.field_41270), FluidVariant::getRegistryEntry,
			class_9326.field_49590, FluidVariant::getComponents,
			FluidVariantImpl::of
	);
}
