/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.transfer.v1.item;

import java.util.Objects;

import com.mojang.serialization.Codec;
import org.jetbrains.annotations.ApiStatus;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.impl.transfer.VariantCodecs;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantImpl;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;

/**
 * An immutable count-less ItemStack, i.e. an immutable association of an item and its data components.
 *
 * <p>Do not implement, use the static {@code of(...)} functions instead.
 */
@ApiStatus.NonExtendable
public interface ItemVariant extends TransferVariant<class_1792> {
	Codec<ItemVariant> CODEC = VariantCodecs.ITEM_CODEC;
	class_9139<class_9129, ItemVariant> PACKET_CODEC = VariantCodecs.ITEM_PACKET_CODEC;

	/**
	 * Retrieve a blank ItemVariant.
	 */
	static ItemVariant blank() {
		return of(class_1802.field_8162);
	}

	/**
	 * Retrieve an ItemVariant with the item and tag of a stack.
	 */
	static ItemVariant of(class_1799 stack) {
		return of(stack.method_7909(), stack.method_57380());
	}

	/**
	 * Retrieve an ItemVariant with an item and without a tag.
	 */
	static ItemVariant of(class_1935 item) {
		return of(item, class_9326.field_49588);
	}

	/**
	 * Retrieve an ItemVariant with an item and an optional tag.
	 */
	static ItemVariant of(class_1935 item, class_9326 components) {
		return ItemVariantImpl.of(item.method_8389(), components);
	}

	/**
	 * Return true if the item and tag of this variant match those of the passed stack, and false otherwise.
	 */
	default boolean matches(class_1799 stack) {
		return isOf(stack.method_7909()) && Objects.equals(stack.method_57380(), getComponents());
	}

	/**
	 * Return the item of this variant.
	 */
	default class_1792 getItem() {
		return getObject();
	}

	default class_6880<class_1792> getRegistryEntry() {
		return getItem().method_40131();
	}

	/**
	 * Create a new item stack with count 1 from this variant.
	 */
	default class_1799 toStack() {
		return toStack(1);
	}

	/**
	 * Create a new item stack from this variant.
	 *
	 * @param count The count of the returned stack. It may lead to counts higher than maximum stack size.
	 */
	default class_1799 toStack(int count) {
		if (isBlank()) return class_1799.field_8037;
		return new class_1799(getRegistryEntry(), count, getComponents());
	}
}
