/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.mixin.transfer.BundleContentsComponentAccessor;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9276;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;

public class BundleContentsStorage
implements Storage<ItemVariant> {
    private final ContainerItemContext ctx;
    private final List<BundleSlotWrapper> slotCache = new ArrayList<BundleSlotWrapper>();
    private List<StorageView<ItemVariant>> slots = List.of();
    private final class_1792 originalItem;

    public BundleContentsStorage(ContainerItemContext ctx) {
        this.ctx = ctx;
        this.originalItem = ctx.getItemVariant().getItem();
    }

    private boolean updateStack(class_9326 changes, TransactionContext transaction) {
        ItemVariant newVariant = this.ctx.getItemVariant().withComponentChanges(changes);
        return this.ctx.exchange(newVariant, 1L, transaction) > 0L;
    }

    @Override
    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        class_1799 stack;
        StoragePreconditions.notBlankNotNegative(resource, maxAmount);
        if (!this.isStillValid()) {
            return 0L;
        }
        if (maxAmount > Integer.MAX_VALUE) {
            maxAmount = Integer.MAX_VALUE;
        }
        if (!class_9276.method_61667((class_1799)(stack = resource.toStack((int)maxAmount)))) {
            return 0L;
        }
        class_9276.class_9277 builder = new class_9276.class_9277(this.bundleContents());
        int inserted = builder.method_57432(stack);
        if (inserted == 0) {
            return 0L;
        }
        class_9326 changes = class_9326.method_57841().method_57854(class_9334.field_49650, (Object)builder.method_57435()).method_57852();
        if (!this.updateStack(changes, transaction)) {
            return 0L;
        }
        return inserted;
    }

    @Override
    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative(maxAmount);
        if (!this.isStillValid()) {
            return 0L;
        }
        this.updateSlotsIfNeeded();
        long amount = 0L;
        for (StorageView<ItemVariant> slot : this.slots) {
            if ((amount += slot.extract(resource, maxAmount - amount, transaction)) == maxAmount) break;
        }
        return amount;
    }

    @Override
    public Iterator<StorageView<ItemVariant>> iterator() {
        this.updateSlotsIfNeeded();
        return this.slots.iterator();
    }

    private boolean isStillValid() {
        return this.ctx.getItemVariant().getItem() == this.originalItem;
    }

    private void updateSlotsIfNeeded() {
        int bundleSize = this.bundleContents().method_57426();
        if (this.slots.size() != bundleSize) {
            while (bundleSize > this.slotCache.size()) {
                this.slotCache.add(new BundleSlotWrapper(this.slotCache.size()));
            }
            this.slots = Collections.unmodifiableList(this.slotCache.subList(0, bundleSize));
        }
    }

    class_9276 bundleContents() {
        return (class_9276)this.ctx.getItemVariant().getComponentMap().method_57830(class_9334.field_49650, (Object)class_9276.field_49289);
    }

    private class BundleSlotWrapper
    implements StorageView<ItemVariant> {
        private final int index;

        private BundleSlotWrapper(int index) {
            this.index = index;
        }

        private class_1799 getStack() {
            if (BundleContentsStorage.this.bundleContents().method_57426() <= this.index) {
                return class_1799.field_8037;
            }
            return (class_1799)((List)BundleContentsStorage.this.bundleContents().method_57421()).get(this.index);
        }

        @Override
        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            class_9326 changes;
            StoragePreconditions.notNegative(maxAmount);
            if (!BundleContentsStorage.this.isStillValid()) {
                return 0L;
            }
            if (BundleContentsStorage.this.bundleContents().method_57426() <= this.index) {
                return 0L;
            }
            if (!resource.matches(this.getStack())) {
                return 0L;
            }
            ArrayList stacksCopy = new ArrayList((Collection)BundleContentsStorage.this.bundleContents().method_59708());
            int extracted = (int)Math.min((long)((class_1799)stacksCopy.get(this.index)).method_7947(), maxAmount);
            ((class_1799)stacksCopy.get(this.index)).method_7934(extracted);
            if (((class_1799)stacksCopy.get(this.index)).method_7960()) {
                stacksCopy.remove(this.index);
            }
            if (!BundleContentsStorage.this.updateStack(changes = class_9326.method_57841().method_57854(class_9334.field_49650, (Object)new class_9276(stacksCopy)).method_57852(), transaction)) {
                return 0L;
            }
            return extracted;
        }

        @Override
        public boolean isResourceBlank() {
            return this.getStack().method_7960();
        }

        @Override
        public ItemVariant getResource() {
            return ItemVariant.of(this.getStack());
        }

        @Override
        public long getAmount() {
            return this.getStack().method_7947();
        }

        @Override
        public long getCapacity() {
            Fraction remainingSpace = Fraction.ONE.subtract(BundleContentsStorage.this.bundleContents().method_57428());
            int extraAllowed = Math.max(remainingSpace.divideBy(BundleContentsComponentAccessor.getOccupancy(this.getStack())).intValue(), 0);
            return this.getAmount() + (long)extraAllowed;
        }
    }
}

