/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.transfer;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.transfer.item.SpecialLogicInventory;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

/**
 * Defer cook time updates for furnaces, so that aborted transactions don't reset the cook time.
 */
@Mixin(class_2609.class)
public abstract class AbstractFurnaceBlockEntityMixin extends class_2624 implements SpecialLogicInventory {
	@Shadow
	protected class_2371<class_1799> inventory;
	@Shadow
	int field_55576;
	@Shadow
	int cookTimeTotal;
	@Unique
	private boolean fabric_suppressSpecialLogic = false;

	protected AbstractFurnaceBlockEntityMixin(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
		super(blockEntityType, blockPos, blockState);
		throw new AssertionError();
	}

	@Inject(at = @At("HEAD"), method = "setStack", cancellable = true)
	public void setStackSuppressUpdate(int slot, class_1799 stack, CallbackInfo ci) {
		if (fabric_suppressSpecialLogic) {
			inventory.set(slot, stack);
			ci.cancel();
		}
	}

	@Override
	public void fabric_setSuppress(boolean suppress) {
		fabric_suppressSpecialLogic = suppress;
	}

	@Override
	public void fabric_onFinalCommit(int slot, class_1799 oldStack, class_1799 newStack) {
		if (slot == 0) {
			class_1799 itemStack = oldStack;
			class_1799 stack = newStack;

			// Update cook time if needed. Code taken from AbstractFurnaceBlockEntity#setStack.
			boolean bl = !stack.method_7960() && class_1799.method_31577(stack, itemStack);

			if (!bl && this.field_11863 instanceof class_3218 world) {
				this.cookTimeTotal = getCookTime(world, (class_2609) (Object) this);
				this.field_55576 = 0;
			}
		}
	}

	@Shadow
	private static int getCookTime(class_3218 world, class_2609 abstractFurnaceBlockEntity) {
		throw new AssertionError();
	}
}
