/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.fabricmc.fabric.impl.transfer.item.InventorySlotWrapper;
import net.fabricmc.fabric.impl.transfer.item.PlayerInventoryStorageImpl;
import net.fabricmc.fabric.impl.transfer.item.SidedInventoryStorageImpl;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import org.jspecify.annotations.Nullable;

public class InventoryStorageImpl
extends CombinedStorage<ItemVariant, SingleSlotStorage<ItemVariant>>
implements InventoryStorage {
    private static final Map<Container, InventoryStorageImpl> WRAPPERS = new MapMaker().weakValues().makeMap();
    final Container inventory;
    final List<InventorySlotWrapper> backingList;
    final MarkDirtyParticipant markDirtyParticipant = new MarkDirtyParticipant();

    public static InventoryStorage of(Container inventory, @Nullable Direction direction) {
        InventoryStorageImpl storage = WRAPPERS.computeIfAbsent(inventory, inv -> {
            if (inv instanceof Inventory) {
                Inventory playerInventory = (Inventory)inv;
                return new PlayerInventoryStorageImpl(playerInventory);
            }
            return new InventoryStorageImpl((Container)inv);
        });
        storage.resizeSlotList();
        return storage.getSidedWrapper(direction);
    }

    InventoryStorageImpl(Container inventory) {
        super(Collections.emptyList());
        this.inventory = inventory;
        this.backingList = new ArrayList<InventorySlotWrapper>();
    }

    @Override
    public List<SingleSlotStorage<ItemVariant>> getSlots() {
        return this.parts;
    }

    private void resizeSlotList() {
        int inventorySize = this.inventory.getContainerSize();
        if (inventorySize != this.parts.size()) {
            while (this.backingList.size() < inventorySize) {
                this.backingList.add(new InventorySlotWrapper(this, this.backingList.size()));
            }
            this.parts = Collections.unmodifiableList(this.backingList.subList(0, inventorySize));
        }
    }

    private InventoryStorage getSidedWrapper(@Nullable Direction direction) {
        if (this.inventory instanceof WorldlyContainer && direction != null) {
            return new SidedInventoryStorageImpl(this, direction);
        }
        return this;
    }

    @Override
    public String toString() {
        return "InventoryStorage[" + DebugMessages.forInventory(this.inventory) + "]";
    }

    class MarkDirtyParticipant
    extends SnapshotParticipant<Boolean> {
        MarkDirtyParticipant() {
        }

        @Override
        protected Boolean createSnapshot() {
            return Boolean.TRUE;
        }

        @Override
        protected void readSnapshot(Boolean snapshot) {
        }

        @Override
        protected void onFinalCommit() {
            InventoryStorageImpl.this.inventory.setChanged();
        }
    }
}

