/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.transfer;

import com.llamalad7.mixinextras.sugar.Local;
import net.fabricmc.fabric.api.transfer.v1.item.ContainerStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HopperBlockEntity.class})
public class HopperBlockEntityMixin {
    @Shadow
    private Direction facing;

    @Inject(at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;getAttachedContainer(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;)Lnet/minecraft/world/Container;")}, method={"ejectItems"}, cancellable=true)
    private static void hookInsert(Level level, BlockPos pos, HopperBlockEntity blockEntity, CallbackInfoReturnable<Boolean> cir, @Local(name={"container"}) Container container) {
        if (container != null) {
            return;
        }
        Direction direction = ((HopperBlockEntityMixin)blockEntity).facing;
        BlockPos targetPos = pos.relative(direction);
        Storage target = (Storage)ItemStorage.SIDED.find(level, targetPos, (Object)direction.getOpposite());
        if (target != null) {
            long moved = StorageUtil.move(ContainerStorage.of((Container)blockEntity, direction), target, iv -> true, 1L, null);
            cir.setReturnValue((Object)(moved == 1L ? 1 : 0));
        }
    }

    @Inject(at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;getSourceContainer(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/Container;")}, method={"suckInItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;)Z"}, cancellable=true)
    private static void hookExtract(Level level, Hopper hopper, CallbackInfoReturnable<Boolean> cir, @Local(name={"container"}) Container container) {
        if (container != null) {
            return;
        }
        BlockPos sourcePos = BlockPos.containing((double)hopper.getLevelX(), (double)(hopper.getLevelY() + 1.0), (double)hopper.getLevelZ());
        Storage source = (Storage)ItemStorage.SIDED.find(level, sourcePos, (Object)Direction.DOWN);
        if (source != null) {
            long moved = StorageUtil.move(source, ContainerStorage.of((Container)hopper, Direction.UP), iv -> true, 1L, null);
            cir.setReturnValue((Object)(moved == 1L ? 1 : 0));
        }
    }
}

