/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.transformer;

import java.util.ArrayList;
import java.util.Collection;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassStripper
extends ClassVisitor {
    private final Collection<String> stripInterfaces;
    private final Collection<String> stripFields;
    private final Collection<String> stripMethods;

    public ClassStripper(int api, ClassVisitor classVisitor, Collection<String> stripInterfaces, Collection<String> stripFields, Collection<String> stripMethods) {
        super(api, classVisitor);
        this.stripInterfaces = stripInterfaces;
        this.stripFields = stripFields;
        this.stripMethods = stripMethods;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (!this.stripInterfaces.isEmpty()) {
            ArrayList<String> interfacesList = new ArrayList<String>();
            for (String itf : interfaces) {
                if (this.stripInterfaces.contains(itf)) continue;
                interfacesList.add(itf);
            }
            interfaces = interfacesList.toArray(new String[0]);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if (this.stripFields.contains(name + descriptor)) {
            return null;
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.stripMethods.contains(name + descriptor)) {
            return null;
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }
}

