/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.nativeplatform;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.loom.nativeplatform.LoomNativePlatformImpl;
import net.fabricmc.loom.nativeplatform.LoomNativePlatformUtils;

public final class LoomNativePlatform {
    private LoomNativePlatform() {
    }

    public static List<ProcessHandle> getProcessesWithLockOn(Path path) {
        if (LoomNativePlatformUtils.isReady()) {
            long[] pids = LoomNativePlatformImpl.getPidsHoldingFileHandles(path.toString());
            return Arrays.stream(pids).mapToObj(ProcessHandle::of).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<String> getWindowTitlesForPid(long pid) {
        if (LoomNativePlatformUtils.isReady()) {
            return Arrays.asList(LoomNativePlatformImpl.getWindowTitlesForPid(pid));
        }
        return Collections.emptyList();
    }

    public static boolean isSupported() {
        return LoomNativePlatformUtils.isReady();
    }
}

